/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.database.postgresql;

import java.util.Map;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.objs.HasShortName;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.database.DatabaseNode;
import org.apache.brooklyn.entity.database.DatastoreMixins;
import org.apache.brooklyn.entity.database.postgresql.PostgreSqlNodeImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="PostgreSQL Node", description="PostgreSQL is an object-relational database management system (ORDBMS)", iconUrl="classpath:///postgresql-logo-200px.png")
@ImplementedBy(value=PostgreSqlNodeImpl.class)
public interface PostgreSqlNode
extends SoftwareProcess,
HasShortName,
DatastoreMixins.DatastoreCommon,
DatabaseNode {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"9.3-3");
    @SetFromFlag(value="configFileUrl")
    public static final ConfigKey<String> CONFIGURATION_FILE_URL = ConfigKeys.newStringConfigKey((String)"postgresql.config.file.url", (String)"URL where PostgreSQL configuration file can be found; if not supplied the blueprint uses the default and customises it");
    @SetFromFlag(value="authConfigFileUrl")
    public static final ConfigKey<String> AUTHENTICATION_CONFIGURATION_FILE_URL = ConfigKeys.newStringConfigKey((String)"postgresql.authConfig.file.url", (String)"URL where PostgreSQL host-based authentication configuration file can be found; if not supplied the blueprint uses the default and customises it");
    @SetFromFlag(value="port")
    public static final PortAttributeSensorAndConfigKey POSTGRESQL_PORT = new PortAttributeSensorAndConfigKey("postgresql.port", "PostgreSQL port", (Object)PortRanges.fromString((String)"5432+"));
    @SetFromFlag(value="sharedMemory")
    public static final ConfigKey<String> SHARED_MEMORY = ConfigKeys.newStringConfigKey((String)"postgresql.sharedMemory", (String)"Size of shared memory buffer (must specify as kB, MB or GB, minimum 128kB)", (String)"4MB");
    @SetFromFlag(value="maxConnections")
    public static final ConfigKey<Integer> MAX_CONNECTIONS = ConfigKeys.newIntegerConfigKey((String)"postgresql.maxConnections", (String)"Maximum number of connections to the database", (Integer)100);
    @SetFromFlag(value="disconnectOnStop")
    public static final ConfigKey<Boolean> DISCONNECT_ON_STOP = ConfigKeys.newBooleanConfigKey((String)"postgresql.disconnect.on.stop", (String)"If true, PostgreSQL will immediately disconnet (pg_ctl -m immediate stop) all current connections when the node is stopped", (Boolean)true);
    @SetFromFlag(value="pollPeriod")
    public static final ConfigKey<Long> POLL_PERIOD = ConfigKeys.newLongConfigKey((String)"postgresql.sensorpoll", (String)"Poll period (in milliseconds)", (Long)1000L);
    @SetFromFlag(value="initializeDB")
    public static final ConfigKey<Boolean> INITIALIZE_DB = ConfigKeys.newBooleanConfigKey((String)"postgresql.initialize", (String)"If true, PostgreSQL will create a new user and database", (Boolean)false);
    @SetFromFlag(value="username")
    public static final BasicAttributeSensorAndConfigKey<String> USERNAME = new BasicAttributeSensorAndConfigKey(String.class, "postgresql.username", "Username of the database user");
    public static final String DEFAULT_USERNAME = "postgresqluser";
    @SetFromFlag(value="roles")
    public static final ConfigKey<Map<String, Map<String, ?>>> ROLES = new MapConfigKey(Map.class, "postgresql.roles", "Set roles with properties and permissions. Shoud be a map with keys equal to role names and values a map of the type:key equal to `properties` and value - the role properties that should be in the query after `WITH` statementkey equal to `privileges` and value - the `GRANT` query value between the `GRANT` and `TO` statements.\nExample:\n Developer:\n  properties: CREATEDB LOGIN\n  privileges: [\"SELECT, INSERT, UPDATE, DELETE ON ALL TABLES IN SCHEMA public\", \"EXECUTE ON ALL FUNCTIONS IN SCHEMA public\"]\nAnalyst:\n  privileges: SELECT ON ALL TABLES IN SCHEMA public");
    public static final String ROLE_PROPERTIES_KEY = "properties";
    public static final String ROLE_PRIVILEGES_KEY = "privileges";
    @SetFromFlag(value="password")
    public static final BasicAttributeSensorAndConfigKey<String> PASSWORD = new BasicAttributeSensorAndConfigKey(String.class, "postgresql.password", "Password for the database user, auto-generated if not set");
    @SetFromFlag(value="database")
    public static final BasicAttributeSensorAndConfigKey<String> DATABASE = new BasicAttributeSensorAndConfigKey(String.class, "postgresql.database", "Database to be used");
    public static final String DEFAULT_DB_NAME = "db";
    public static final Effector<String> EXECUTE_SCRIPT = Effectors.effector(DatastoreMixins.EXECUTE_SCRIPT).description("Executes the given script contents using psql").buildAbstract();

    public Integer getPostgreSqlPort();

    public String getSharedMemory();

    public Integer getMaxConnections();

    public String executeScript(String var1);
}

