/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.tomcat;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.objs.HasShortName;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.webapp.JavaWebAppService;
import org.apache.brooklyn.entity.webapp.JavaWebAppSoftwareProcess;
import org.apache.brooklyn.entity.webapp.tomcat.TomcatServerImpl;
import org.apache.brooklyn.util.core.ResourcePredicates;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Tomcat 7 Server", description="Apache Tomcat is an open source software implementation of the Java Servlet and JavaServer Pages technologies", iconUrl="classpath:///tomcat-logo.png")
@ImplementedBy(value=TomcatServerImpl.class)
public interface TomcatServer
extends JavaWebAppSoftwareProcess,
UsesJmx,
HasShortName {
    @CatalogConfig(label="Root WAR")
    @SetFromFlag(value="war")
    public static final ConfigKey<String> ROOT_WAR = JavaWebAppService.ROOT_WAR;
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"7.0.65");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"apache-tomcat-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"http://download.nextag.com/apache/tomcat/tomcat-7/v${version}/bin/apache-tomcat-${version}.tar.gz");
    @SetFromFlag(value="shutdownPort")
    public static final PortAttributeSensorAndConfigKey SHUTDOWN_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"tomcat.shutdownport", (String)"Suggested shutdown port", (Object)PortRanges.fromString((String)"31880+"));
    @SetFromFlag(value="server.xml")
    public static final ConfigKey<String> SERVER_XML_RESOURCE = ConfigKeys.builder(String.class).name("tomcat.serverxml").description("The file to template and use as the Tomcat's server.xml").defaultValue((Object)JavaClassNames.resolveClasspathUrl(TomcatServer.class, (String)"server.xml")).constraint(ResourcePredicates.urlExists()).build();
    @SetFromFlag(value="web.xml")
    public static final ConfigKey<String> WEB_XML_RESOURCE = ConfigKeys.builder(String.class).name("tomcat.webxml").description("The file to template and use as the Tomcat's web.xml").defaultValue((Object)JavaClassNames.resolveClasspathUrl(TomcatServer.class, (String)"web.xml")).constraint(ResourcePredicates.urlExists()).build();
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    public static final AttributeSensor<String> CONNECTOR_STATUS = Sensors.newStringSensor((String)"webapp.tomcat.connectorStatus", (String)"Catalina connector state name");
    public static final AttributeSensor<String> JMX_SERVICE_URL = UsesJmx.JMX_URL;
}

