/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.security.provider;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.PasswordHasher;
import org.apache.brooklyn.rest.security.provider.AbstractSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitUsersSecurityProvider
extends AbstractSecurityProvider
implements SecurityProvider {
    public static final Logger LOG = LoggerFactory.getLogger(ExplicitUsersSecurityProvider.class);
    protected final ManagementContext mgmt;
    private boolean allowAnyUserWithValidPass;
    private Set<String> allowedUsers = null;

    public ExplicitUsersSecurityProvider(ManagementContext mgmt) {
        this.mgmt = mgmt;
        this.initialize();
    }

    private synchronized void initialize() {
        if (this.allowedUsers != null) {
            return;
        }
        StringConfigMap properties = this.mgmt.getConfig();
        this.allowedUsers = new LinkedHashSet<String>();
        String users = (String)properties.getConfig(BrooklynWebConfig.USERS);
        if (users == null) {
            LOG.warn("REST has no users configured; no one will be able to log in!");
        } else if ("*".equals(users)) {
            LOG.info("REST allowing any user (so long as valid password is set)");
            this.allowAnyUserWithValidPass = true;
        } else {
            StringTokenizer t = new StringTokenizer(users, ",");
            while (t.hasMoreElements()) {
                this.allowedUsers.add(("" + t.nextElement()).trim());
            }
            LOG.info("REST allowing users: " + this.allowedUsers);
        }
    }

    @Override
    public boolean authenticate(HttpSession session, String user, String password) {
        if (session == null || user == null) {
            return false;
        }
        if (!this.allowAnyUserWithValidPass && !this.allowedUsers.contains(user)) {
            LOG.debug("REST rejecting unknown user " + user);
            return false;
        }
        if (ExplicitUsersSecurityProvider.checkExplicitUserPassword(this.mgmt, user, password)) {
            return this.allow(session, user);
        }
        return false;
    }

    public static boolean checkExplicitUserPassword(ManagementContext mgmt, String user, String password) {
        BrooklynProperties properties = (BrooklynProperties)mgmt.getConfig();
        String expectedPassword = (String)properties.getConfig(BrooklynWebConfig.PASSWORD_FOR_USER(user));
        String salt = (String)properties.getConfig(BrooklynWebConfig.SALT_FOR_USER(user));
        String expectedSha256 = (String)properties.getConfig(BrooklynWebConfig.SHA256_FOR_USER(user));
        return ExplicitUsersSecurityProvider.checkPassword(password, expectedPassword, expectedSha256, salt);
    }

    public static boolean checkPassword(String candidatePassword, String expectedPassword, String expectedPasswordSha256, String salt) {
        if (expectedPassword != null) {
            return expectedPassword.equals(candidatePassword);
        }
        if (expectedPasswordSha256 != null) {
            String hashedCandidatePassword = PasswordHasher.sha256(salt, candidatePassword);
            return expectedPasswordSha256.equals(hashedCandidatePassword);
        }
        return false;
    }
}

