/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.security.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpSession;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.provider.BlackholeSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingSecurityProvider
implements SecurityProvider {
    private static final Logger log = LoggerFactory.getLogger(DelegatingSecurityProvider.class);
    protected final ManagementContext mgmt;
    private SecurityProvider delegate;
    private final AtomicLong modCount = new AtomicLong();

    public DelegatingSecurityProvider(ManagementContext mgmt) {
        this.mgmt = mgmt;
        mgmt.addPropertiesReloadListener((ManagementContext.PropertiesReloadListener)new PropertiesListener());
    }

    public synchronized SecurityProvider getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.loadDelegate();
        }
        return this.delegate;
    }

    private synchronized SecurityProvider loadDelegate() {
        StringConfigMap brooklynProperties = this.mgmt.getConfig();
        SecurityProvider presetDelegate = (SecurityProvider)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE);
        if (presetDelegate != null) {
            log.info("REST using pre-set security provider " + presetDelegate);
            return presetDelegate;
        }
        String className = (String)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME);
        if (this.delegate != null && BrooklynWebConfig.hasNoSecurityOptions((ConfigMap)this.mgmt.getConfig())) {
            log.debug("{} refusing to change from {}: No security provider set in reloaded properties.", (Object)this, (Object)this.delegate);
            return this.delegate;
        }
        log.info("REST using security provider " + className);
        try {
            Class clazz;
            ClassLoaderUtils clu = new ClassLoaderUtils((Object)this, this.mgmt);
            try {
                clazz = clu.loadClass(className);
            }
            catch (Exception e) {
                String oldPackage = "brooklyn.web.console.security.";
                if (className.startsWith(oldPackage)) {
                    className = Strings.removeFromStart((String)className, (String)oldPackage);
                    className = DelegatingSecurityProvider.class.getPackage().getName() + "." + className;
                    clazz = clu.loadClass(className);
                    log.warn("Deprecated package " + oldPackage + " detected; please update security provider to point to " + className);
                }
                throw e;
            }
            this.delegate = DelegatingSecurityProvider.createSecurityProviderInstance(this.mgmt, clazz);
        }
        catch (Exception e) {
            log.warn("REST unable to instantiate security provider " + className + "; all logins are being disallowed", (Throwable)e);
            this.delegate = new BlackholeSecurityProvider();
        }
        ((BrooklynProperties)this.mgmt.getConfig()).put(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE, (Object)this.delegate);
        this.mgmt.getScratchpad().put(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE, (Object)this.delegate);
        return this.delegate;
    }

    public static SecurityProvider createSecurityProviderInstance(ManagementContext mgmt, Class<? extends SecurityProvider> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            Constructor<? extends SecurityProvider> constructor = clazz.getConstructor(ManagementContext.class);
            return constructor.newInstance(mgmt);
        }
        catch (Exception e) {
            Constructor<? extends SecurityProvider> constructor = clazz.getConstructor(new Class[0]);
            SecurityProvider delegateO = constructor.newInstance(new Object[0]);
            if (!(delegateO instanceof SecurityProvider)) {
                throw new ClassCastException("Delegate is either not a security provider or has an incompatible classloader: " + delegateO);
            }
            return delegateO;
        }
    }

    protected void invalidateExistingSessions() {
        this.modCount.incrementAndGet();
    }

    @Override
    public boolean isAuthenticated(HttpSession session) {
        if (session == null) {
            return false;
        }
        Object modCountWhenFirstAuthenticated = session.getAttribute(this.getModificationCountKey());
        boolean authenticated = this.getDelegate().isAuthenticated(session) && Long.valueOf(this.modCount.get()).equals(modCountWhenFirstAuthenticated);
        return authenticated;
    }

    @Override
    public boolean authenticate(HttpSession session, String user, String password) {
        boolean authenticated = this.getDelegate().authenticate(session, user, password);
        if (authenticated) {
            session.setAttribute(this.getModificationCountKey(), (Object)this.modCount.get());
        }
        if (log.isTraceEnabled() && authenticated) {
            log.trace("User {} authenticated with provider {}", (Object)user, (Object)this.getDelegate());
        } else if (!authenticated && log.isDebugEnabled()) {
            log.debug("Failed authentication for user {} with provider {}", (Object)user, (Object)this.getDelegate());
        }
        return authenticated;
    }

    @Override
    public boolean logout(HttpSession session) {
        boolean logout = this.getDelegate().logout(session);
        if (logout) {
            session.removeAttribute(this.getModificationCountKey());
        }
        return logout;
    }

    private String getModificationCountKey() {
        return this.getClass().getName() + ".ModCount";
    }

    private class PropertiesListener
    implements ManagementContext.PropertiesReloadListener {
        private static final long serialVersionUID = 8148722609022378917L;

        private PropertiesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reloaded() {
            log.debug("{} reloading security provider", (Object)DelegatingSecurityProvider.this);
            DelegatingSecurityProvider delegatingSecurityProvider = DelegatingSecurityProvider.this;
            synchronized (delegatingSecurityProvider) {
                DelegatingSecurityProvider.this.loadDelegate();
                DelegatingSecurityProvider.this.invalidateExistingSessions();
            }
        }
    }
}

