/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.rest.api.BundleApi;
import org.apache.brooklyn.rest.domain.ApiError;
import org.apache.brooklyn.rest.domain.BundleInstallationRestResult;
import org.apache.brooklyn.rest.domain.BundleSummary;
import org.apache.brooklyn.rest.domain.TypeDetail;
import org.apache.brooklyn.rest.domain.TypeSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.resources.TypeResource;
import org.apache.brooklyn.rest.transform.TypeTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class BundleResource
extends AbstractBrooklynRestResource
implements BundleApi {
    private static final Logger log = LoggerFactory.getLogger(BundleResource.class);
    private static final String LATEST = "latest";

    public List<BundleSummary> list(String versions, boolean detail) {
        return this.list((Predicate<String>)Predicates.alwaysTrue(), TypeResource.isLatestOnly(versions, true), detail);
    }

    private List<BundleSummary> list(Predicate<String> symbolicNameFilter, boolean onlyLatest, boolean detail) {
        TreeMap<VersionedName, ManagedBundle> bundles = new TreeMap<VersionedName, ManagedBundle>((Comparator<VersionedName>)VersionedName.VersionedNameComparator.INSTANCE);
        for (ManagedBundle b : ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).getManagedBundles().values()) {
            VersionedName key;
            ManagedBundle oldBundle;
            if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)b.getId()) || !symbolicNameFilter.apply((Object)b.getSymbolicName()) || (oldBundle = (ManagedBundle)bundles.get(key = onlyLatest ? new VersionedName(b.getSymbolicName(), LATEST) : b.getVersionedName())) != null && oldBundle.getVersionedName().compareTo(b.getVersionedName()) <= 0) continue;
            bundles.put(key, b);
        }
        return this.toBundleSummary(bundles.values(), detail);
    }

    private List<BundleSummary> toBundleSummary(Iterable<ManagedBundle> sortedItems, boolean detail) {
        MutableList result = MutableList.of();
        for (ManagedBundle t : sortedItems) {
            result.add(TypeTransformer.bundleSummary(this.brooklyn(), t, this.ui.getBaseUriBuilder(), this.mgmt(), detail));
        }
        return result;
    }

    public List<BundleSummary> listVersions(String symbolicName, boolean detail) {
        return this.list((Predicate<String>)Predicates.equalTo((Object)symbolicName), false, detail);
    }

    public BundleSummary detail(String symbolicName, String version) {
        ManagedBundle b = this.lookup(symbolicName, version);
        return TypeTransformer.bundleDetails(this.brooklyn(), b, this.ui.getBaseUriBuilder(), this.mgmt());
    }

    protected ManagedBundle lookup(String symbolicName, String version) {
        ManagedBundle b = ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).getManagedBundle(new VersionedName(symbolicName, version));
        if (b == null) {
            throw WebResourceUtils.notFound("Bundle with id '%s:%s' not found", symbolicName, version);
        }
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)b.getId())) {
            throw WebResourceUtils.notFound("Bundle with id '%s:%s' not found", symbolicName, version);
        }
        return b;
    }

    public List<TypeSummary> getTypes(String symbolicName, String version) {
        ManagedBundle b = this.lookup(symbolicName, version);
        return TypeTransformer.bundleDetails(this.brooklyn(), b, this.ui.getBaseUriBuilder(), this.mgmt()).getTypes();
    }

    public TypeDetail getType(String symbolicName, String version, String typeSymbolicName) {
        return this.getTypeExplicitVersion(symbolicName, version, typeSymbolicName, version);
    }

    public TypeDetail getTypeExplicitVersion(String symbolicName, String version, String typeSymbolicName, String typeVersion) {
        Iterable items;
        ManagedBundle b = this.lookup(symbolicName, version);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_CATALOG_ITEM, (Object)(typeSymbolicName + ":" + typeVersion))) {
            throw WebResourceUtils.forbidden("User '%s' not permitted to see info on this type (including whether or not installed)", Entitlements.getEntitlementContext().user());
        }
        Predicate pred = RegisteredTypePredicates.nameOrAlias((String)typeSymbolicName);
        pred = Predicates.and((Predicate)pred, (Predicate)RegisteredTypePredicates.containingBundle((VersionedName)b.getVersionedName()));
        if (!LATEST.equalsIgnoreCase(typeVersion)) {
            pred = Predicates.and((Predicate)pred, (Predicate)RegisteredTypePredicates.version((String)typeVersion));
        }
        if (Iterables.isEmpty((Iterable)(items = this.mgmt().getTypeRegistry().getMatching(pred)))) {
            throw WebResourceUtils.notFound("Entity with id '%s:%s' not found", typeSymbolicName, typeVersion);
        }
        RegisteredType item = RegisteredTypes.getBestVersion((Iterable)items);
        return TypeTransformer.detail(this.brooklyn(), item, this.ui.getBaseUriBuilder());
    }

    public BundleInstallationRestResult remove(String symbolicName, String version, Boolean force) {
        ManagedBundle b = this.lookup(symbolicName, version);
        log.info("REST removing " + symbolicName + ":" + version);
        if (force == null) {
            force = false;
        }
        ReferenceWithError r = ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).uninstallUploadedBundle(b, force.booleanValue());
        return TypeTransformer.bundleInstallationResult((OsgiBundleInstallationResult)r.getWithoutError(), this.mgmt(), this.brooklyn(), this.ui);
    }

    public Response createFromYaml(String yaml, Boolean force) {
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ADD_CATALOG_ITEM, (Object)yaml)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to add catalog items", Entitlements.getEntitlementContext().user());
        }
        if (force == null) {
            force = false;
        }
        try {
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)TypeTransformer.bundleInstallationResult(((BasicBrooklynCatalog)this.brooklyn().getCatalog()).addItemsBundleResult(yaml, force.booleanValue()), this.mgmt(), this.brooklyn(), this.ui)).build();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return this.badRequest(e);
        }
    }

    public Response createFromArchive(byte[] zipInput, Boolean force) {
        Response.Status status;
        ReferenceWithError result;
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.ROOT, null)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to add catalog items", Entitlements.getEntitlementContext().user());
        }
        if (force == null) {
            force = false;
        }
        if ((result = ((OsgiManager)((ManagementContextInternal)this.mgmt()).getOsgiManager().get()).install(null, (InputStream)new ByteArrayInputStream(zipInput), true, true, force.booleanValue())).hasError()) {
            if (log.isTraceEnabled()) {
                log.trace("Unable to create from archive, returning 400: " + result.getError().getMessage(), result.getError());
            }
            return ApiError.builder().errorCode(Response.Status.BAD_REQUEST).message(((OsgiBundleInstallationResult)result.getWithoutError()).getMessage()).data((Object)TypeTransformer.bundleInstallationResult((OsgiBundleInstallationResult)result.getWithoutError(), this.mgmt(), this.brooklyn(), this.ui)).build().asJsonResponse();
        }
        BundleInstallationRestResult resultR = TypeTransformer.bundleInstallationResult((OsgiBundleInstallationResult)result.get(), this.mgmt(), this.brooklyn(), this.ui);
        switch (((OsgiBundleInstallationResult)result.get()).getCode()) {
            case IGNORING_BUNDLE_AREADY_INSTALLED: 
            case IGNORING_BUNDLE_FORCIBLY_REMOVED: {
                status = Response.Status.OK;
                break;
            }
            default: {
                status = Response.Status.CREATED;
            }
        }
        return Response.status((Response.Status)status).entity((Object)resultR).build();
    }
}

