/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.Throwables;
import java.net.MalformedURLException;
import java.net.URL;
import org.jclouds.azurecompute.domain.StorageServiceKeys;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public class StorageServiceKeysHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<StorageServiceKeys> {
    private URL url;
    private String primary;
    private String secondary;
    private final StringBuilder currentText = new StringBuilder();

    public StorageServiceKeys getResult() {
        StorageServiceKeys result = StorageServiceKeys.create(this.url, this.primary, this.secondary);
        this.url = null;
        this.primary = null;
        this.secondary = null;
        return result;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if ("Url".equals(qName)) {
            String urlText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (urlText != null) {
                try {
                    this.url = new URL(urlText);
                }
                catch (MalformedURLException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        } else if ("Primary".equals(qName)) {
            this.primary = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("Secondary".equals(qName)) {
            this.secondary = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

