/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.ComputeCapabilities;
import org.jclouds.azurecompute.domain.Location;
import org.jclouds.azurecompute.xml.ComputeCapabilitiesHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class LocationHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Location> {
    private String name;
    private String displayName;
    private final List<String> availableServices = Lists.newArrayList();
    private ComputeCapabilities computeCapabilities;
    private boolean inComputeCapabilities = false;
    private final ComputeCapabilitiesHandler computeCapabilitiesHandler;
    private final StringBuilder currentText = new StringBuilder();

    @Inject
    LocationHandler(ComputeCapabilitiesHandler computeCapabilitiesHandler) {
        this.computeCapabilitiesHandler = computeCapabilitiesHandler;
    }

    public Location getResult() {
        Location result = Location.create(this.name, this.displayName, (List<String>)ImmutableList.copyOf(this.availableServices), this.computeCapabilities);
        this.displayName = null;
        this.name = null;
        this.availableServices.clear();
        this.computeCapabilities = null;
        return result;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ComputeCapabilities".equals(qName)) {
            this.inComputeCapabilities = true;
        } else if (this.inComputeCapabilities) {
            this.computeCapabilitiesHandler.startElement(uri, localName, qName, attributes);
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("DisplayName")) {
            this.displayName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("AvailableService")) {
            this.availableServices.add(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if ("ComputeCapabilities".equals(qName)) {
            this.inComputeCapabilities = false;
            this.computeCapabilities = this.computeCapabilitiesHandler.getResult();
        } else if (this.inComputeCapabilities) {
            this.computeCapabilitiesHandler.endElement(ignoredUri, ignoredName, qName);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inComputeCapabilities) {
            this.computeCapabilitiesHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

