/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import java.net.URI;
import org.jclouds.azurecompute.domain.Disk;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.xml.AttachmentHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

final class DiskHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Disk> {
    private String name;
    private String location;
    private String affinityGroup;
    private String description;
    private OSImage.Type os;
    private URI mediaLink;
    private Integer logicalSizeInGB;
    private Disk.Attachment attachedTo;
    private String sourceImage;
    private boolean inAttachment;
    private final AttachmentHandler attachmentHandler = new AttachmentHandler();
    private final StringBuilder currentText = new StringBuilder();

    DiskHandler() {
    }

    public Disk getResult() {
        Disk result = Disk.create(this.name, this.location, this.affinityGroup, this.description, this.os, this.mediaLink, this.logicalSizeInGB, this.attachedTo, this.sourceImage);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.sourceImage = null;
        this.description = null;
        this.affinityGroup = null;
        this.location = null;
        this.name = null;
        this.os = null;
        this.mediaLink = null;
        this.logicalSizeInGB = null;
        this.attachedTo = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("AttachedTo")) {
            this.inAttachment = true;
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("AttachedTo")) {
            this.attachedTo = this.attachmentHandler.getResult();
            this.inAttachment = false;
        } else if (this.inAttachment) {
            this.attachmentHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("OS")) {
            String osText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (osText != null) {
                this.os = OSImage.Type.valueOf(osText.toUpperCase());
            }
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("LogicalDiskSizeInGB")) {
            String gb = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (gb != null) {
                this.logicalSizeInGB = Integer.parseInt(gb);
            }
        } else if (qName.equals("Description")) {
            this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Location")) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("AffinityGroup")) {
            this.affinityGroup = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("MediaLink")) {
            String link = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (link != null) {
                this.mediaLink = URI.create(link);
            }
        } else if (qName.equals("SourceImageName")) {
            this.sourceImage = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inAttachment) {
            this.attachmentHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

