/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.azurecompute.xml.InputEndpointHandler;
import org.jclouds.azurecompute.xml.SubnetNameHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ConfigurationSetHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Role.ConfigurationSet> {
    private String configurationSetType;
    private List<Role.ConfigurationSet.InputEndpoint> inputEndpoint = Lists.newArrayList();
    private List<Role.ConfigurationSet.SubnetName> subnetNames = Lists.newArrayList();
    private String staticVirtualNetworkIPAddress;
    private List<Role.ConfigurationSet.PublicIP> publicIPs = Lists.newArrayList();
    private String networkSecurityGroup;
    private boolean inInputEndpoint;
    private boolean inSubnetNames;
    private final InputEndpointHandler inputEndpointHandler;
    private final SubnetNameHandler subnetNameHandler;
    private final StringBuilder currentText = new StringBuilder();

    @Inject
    ConfigurationSetHandler(InputEndpointHandler inputEndpointHandler, SubnetNameHandler subnetNameHandler) {
        this.inputEndpointHandler = inputEndpointHandler;
        this.subnetNameHandler = subnetNameHandler;
    }

    public Role.ConfigurationSet getResult() {
        Role.ConfigurationSet result = Role.ConfigurationSet.create(this.configurationSetType, this.inputEndpoint, this.subnetNames, this.staticVirtualNetworkIPAddress, this.publicIPs, this.networkSecurityGroup);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.networkSecurityGroup = null;
        this.staticVirtualNetworkIPAddress = null;
        this.configurationSetType = null;
        this.inputEndpoint = Lists.newArrayList();
        this.subnetNames = Lists.newArrayList();
        this.publicIPs = Lists.newArrayList();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("InputEndpoint")) {
            this.inInputEndpoint = true;
        }
        if (this.inInputEndpoint) {
            this.inputEndpointHandler.startElement(uri, localName, qName, attributes);
        }
        if (qName.equals("SubnetNames")) {
            this.inSubnetNames = true;
        }
        if (this.inSubnetNames) {
            this.subnetNameHandler.startElement(uri, localName, qName, attributes);
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("InputEndpoint")) {
            this.inInputEndpoint = false;
            this.inputEndpoint.add(this.inputEndpointHandler.getResult());
        } else if (qName.equals("SubnetNames")) {
            this.inSubnetNames = false;
            this.subnetNames.add(this.subnetNameHandler.getResult());
        } else if (this.inInputEndpoint) {
            this.inputEndpointHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (this.inSubnetNames) {
            this.subnetNameHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("ConfigurationSetType")) {
            this.configurationSetType = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("NetworkSecurityGroup")) {
            this.networkSecurityGroup = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inInputEndpoint) {
            this.inputEndpointHandler.characters(ch, start, length);
        } else if (this.inSubnetNames) {
            this.subnetNameHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

