/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.suppliers;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.jclouds.util.Closeables2;

class FileBasedKeyManagersSupplier
implements Supplier<KeyManager[]> {
    private final File pkcs12File;
    private final char[] credential;

    public FileBasedKeyManagersSupplier(File pkcs12File, char[] credential) {
        this.pkcs12File = pkcs12File;
        this.credential = credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyManager[] get() {
        KeyManager[] keyManagers = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.pkcs12File);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(stream, this.credential);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, this.credential);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            try {
                Throwables.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly(stream);
                throw throwable;
            }
            Closeables2.closeQuietly((Closeable)stream);
        }
        Closeables2.closeQuietly((Closeable)stream);
        return keyManagers;
    }
}

