/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.VMImageParamsToXML;
import org.jclouds.azurecompute.domain.VMImage;
import org.jclouds.azurecompute.domain.VMImageParams;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.ListVMImagesHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/vmimages")
@Consumes(value={"application/xml"})
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
public interface VMImageApi {
    @Named(value="ListVMImages")
    @GET
    @XMLResponseParser(value=ListVMImagesHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<VMImage> list();

    @Named(value="CreateVMImage")
    @POST
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String create(@BinderParam(value=VMImageParamsToXML.class) VMImageParams var1);

    @Named(value="UpdateVMImage")
    @PUT
    @Path(value="/{imageName}")
    @Produces(value={"application/xml"})
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String update(@PathParam(value="imageName") String var1, @BinderParam(value=VMImageParamsToXML.class) VMImageParams var2);

    @Named(value="DeleteImage")
    @DELETE
    @Path(value="/{imageName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="imageName") String var1);
}

