/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.binders.ReservedIPAddressParamsToXML;
import org.jclouds.azurecompute.domain.ReservedIPAddress;
import org.jclouds.azurecompute.domain.ReservedIPAddressParams;
import org.jclouds.azurecompute.functions.ParseRequestIdHeader;
import org.jclouds.azurecompute.xml.ListReservedIPAddressHandler;
import org.jclouds.azurecompute.xml.ReservedIPAddressHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;

@Path(value="/services/networking/reservedips")
@Headers(keys={"x-ms-version"}, values={"{jclouds.api-version}"})
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public interface ReservedIPAddressApi {
    @Named(value="ListReservedIPAddress")
    @GET
    @XMLResponseParser(value=ListReservedIPAddressHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ReservedIPAddress> list();

    @Named(value="GetReservedIPAddress")
    @GET
    @Path(value="/{name}")
    @XMLResponseParser(value=ReservedIPAddressHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ReservedIPAddress get(@PathParam(value="name") String var1);

    @Named(value="DeleteReservedIPAddress")
    @DELETE
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String delete(@PathParam(value="name") String var1);

    @Named(value="CreateReservedIPAddress")
    @POST
    @ResponseParser(value=ParseRequestIdHeader.class)
    public String create(@BinderParam(value=ReservedIPAddressParamsToXML.class) ReservedIPAddressParams var1);
}

