/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import org.jclouds.azurecompute.domain.AutoValue_Role;
import org.jclouds.azurecompute.domain.AutoValue_Role_ConfigurationSet;
import org.jclouds.azurecompute.domain.AutoValue_Role_ConfigurationSet_InputEndpoint;
import org.jclouds.azurecompute.domain.AutoValue_Role_ConfigurationSet_InputEndpoint_LoadBalancerProbe;
import org.jclouds.azurecompute.domain.AutoValue_Role_ConfigurationSet_PublicIP;
import org.jclouds.azurecompute.domain.AutoValue_Role_ConfigurationSet_SubnetName;
import org.jclouds.azurecompute.domain.AutoValue_Role_OSVirtualHardDisk;
import org.jclouds.azurecompute.domain.AutoValue_Role_ResourceExtensionReference;
import org.jclouds.azurecompute.domain.AutoValue_Role_ResourceExtensionReference_ResourceExtensionParameterValue;
import org.jclouds.azurecompute.domain.DataVirtualHardDisk;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.javax.annotation.Nullable;

public abstract class Role {
    public abstract String roleName();

    public abstract String roleType();

    @Nullable
    public abstract String vmImage();

    @Nullable
    public abstract String mediaLocation();

    public abstract List<ConfigurationSet> configurationSets();

    @Nullable
    public abstract List<ResourceExtensionReference> resourceExtensionReferences();

    @Nullable
    public abstract String availabilitySetName();

    @Nullable
    public abstract List<DataVirtualHardDisk> dataVirtualHardDisks();

    public abstract OSVirtualHardDisk osVirtualHardDisk();

    public abstract RoleSize.Type roleSize();

    @Nullable
    public abstract Boolean provisionGuestAgent();

    @Nullable
    public abstract String defaultWinRmCertificateThumbprint();

    public static Role create(String roleName, String roleType, String vmImage, String mediaLocation, List<ConfigurationSet> configurationSets, List<ResourceExtensionReference> resourceExtensionReferences, String availabilitySetName, List<DataVirtualHardDisk> dataVirtualHardDisks, OSVirtualHardDisk osVirtualHardDisk, RoleSize.Type roleSize, Boolean provisionGuestAgent, String defaultWinRmCertificateThumbprint) {
        return new AutoValue_Role(roleName, roleType, vmImage, mediaLocation, (List<ConfigurationSet>)ImmutableList.copyOf(configurationSets), (List<ResourceExtensionReference>)ImmutableList.copyOf(resourceExtensionReferences), availabilitySetName, (List<DataVirtualHardDisk>)ImmutableList.copyOf(dataVirtualHardDisks), osVirtualHardDisk, roleSize, provisionGuestAgent, defaultWinRmCertificateThumbprint);
    }

    public static abstract class OSVirtualHardDisk {
        public abstract String hostCaching();

        public abstract String diskName();

        @Nullable
        public abstract Integer lun();

        @Nullable
        public abstract Integer logicalDiskSizeInGB();

        public abstract URI mediaLink();

        @Nullable
        public abstract String sourceImageName();

        public abstract OSImage.Type os();

        OSVirtualHardDisk() {
        }

        public static OSVirtualHardDisk create(String hostCaching, String diskName, Integer lun, Integer logicalDiskSizeInGB, URI mediaLink, String sourceImageName, OSImage.Type os) {
            return new AutoValue_Role_OSVirtualHardDisk(hostCaching, diskName, lun, logicalDiskSizeInGB, mediaLink, sourceImageName, os);
        }
    }

    public static abstract class ResourceExtensionReference {
        @Nullable
        public abstract String referenceName();

        @Nullable
        public abstract String publisher();

        @Nullable
        public abstract String name();

        @Nullable
        public abstract String version();

        @Nullable
        public abstract List<ResourceExtensionParameterValue> resourceExtensionParameterValues();

        @Nullable
        public abstract String state();

        ResourceExtensionReference() {
        }

        public static ResourceExtensionReference create(String referenceName, String publisher, String name, String version, List<ResourceExtensionParameterValue> resourceExtensionParameterValues, String state) {
            return new AutoValue_Role_ResourceExtensionReference(referenceName, publisher, name, version, resourceExtensionParameterValues, state);
        }

        public static abstract class ResourceExtensionParameterValue {
            public abstract String key();

            public abstract String value();

            public abstract String type();

            ResourceExtensionParameterValue() {
            }

            public static ResourceExtensionParameterValue create(String key, String value, String type) {
                return new AutoValue_Role_ResourceExtensionReference_ResourceExtensionParameterValue(key, value, type);
            }
        }
    }

    public static abstract class ConfigurationSet {
        public abstract String configurationSetType();

        public abstract List<InputEndpoint> inputEndpoints();

        @Nullable
        public abstract List<SubnetName> subnetNames();

        @Nullable
        public abstract String staticVirtualNetworkIPAddress();

        @Nullable
        public abstract List<PublicIP> publicIPs();

        @Nullable
        public abstract String networkSecurityGroup();

        ConfigurationSet() {
        }

        public static ConfigurationSet create(String configurationSetType, List<InputEndpoint> inputEndpoints, List<SubnetName> subnetNames, String staticVirtualNetworkIPAddress, List<PublicIP> publicIPs, String networkSecurityGroup) {
            return new AutoValue_Role_ConfigurationSet(configurationSetType, inputEndpoints, subnetNames, staticVirtualNetworkIPAddress, publicIPs, networkSecurityGroup);
        }

        public static abstract class PublicIP {
            public abstract String name();

            public abstract int idleTimeoutInMinutes();

            PublicIP() {
            }

            public static PublicIP create(String name, int idleTimeoutInMinutes) {
                return new AutoValue_Role_ConfigurationSet_PublicIP(name, idleTimeoutInMinutes);
            }
        }

        public static abstract class SubnetName {
            @Nullable
            public abstract String name();

            SubnetName() {
            }

            public static SubnetName create(String name) {
                return new AutoValue_Role_ConfigurationSet_SubnetName(name);
            }
        }

        public static abstract class InputEndpoint {
            public abstract int localPort();

            public abstract String name();

            public abstract Integer port();

            public abstract String protocol();

            @Nullable
            public abstract String vip();

            public abstract Boolean enableDirectServerReturn();

            @Nullable
            public abstract String loadBalancerName();

            @Nullable
            public abstract LoadBalancerProbe loadBalancerProbe();

            @Nullable
            public abstract Integer idleTimeoutInMinutes();

            InputEndpoint() {
            }

            public static InputEndpoint create(String name, String protocol, int localPort, int port, String vip, boolean enableDirectServerReturn, String loadBalancerName, LoadBalancerProbe loadBalancerProbe, Integer idleTimeoutInMinutes) {
                return new AutoValue_Role_ConfigurationSet_InputEndpoint(localPort, name, port, protocol, vip, enableDirectServerReturn, loadBalancerName, loadBalancerProbe, idleTimeoutInMinutes);
            }

            public static abstract class LoadBalancerProbe {
                public abstract String path();

                public abstract int port();

                public abstract String protocol();

                LoadBalancerProbe() {
                }

                public static LoadBalancerProbe create(String path, int port, String protocol) {
                    return new AutoValue_Role_ConfigurationSet_InputEndpoint_LoadBalancerProbe(path, port, protocol);
                }
            }
        }
    }
}

