/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import java.util.List;
import org.jclouds.azurecompute.domain.AutoValue_ProfileDefinitionParams;
import org.jclouds.azurecompute.domain.ProfileDefinition;
import org.jclouds.azurecompute.domain.ProfileDefinitionEndpointParams;

public abstract class ProfileDefinitionParams {
    ProfileDefinitionParams() {
    }

    public abstract Integer ttl();

    public abstract ProfileDefinition.Protocol protocol();

    public abstract Integer port();

    public abstract String path();

    public abstract ProfileDefinition.LBMethod lb();

    public abstract List<ProfileDefinitionEndpointParams> endpoints();

    public Builder toBuilder() {
        return ProfileDefinitionParams.builder().fromImageParams(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ProfileDefinitionParams create(Integer ttl, ProfileDefinition.Protocol protocol, Integer port, String path, ProfileDefinition.LBMethod lb, List<ProfileDefinitionEndpointParams> endpoints) {
        return new AutoValue_ProfileDefinitionParams(ttl, protocol, port, path, lb, endpoints);
    }

    public static final class Builder {
        private Integer ttl;
        private ProfileDefinition.Protocol protocol;
        private Integer port;
        private String path;
        private ProfileDefinition.LBMethod lb;
        private List<ProfileDefinitionEndpointParams> endpoints;

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder protocol(ProfileDefinition.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder lb(ProfileDefinition.LBMethod lb) {
            this.lb = lb;
            return this;
        }

        public Builder endpoints(List<ProfileDefinitionEndpointParams> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public ProfileDefinitionParams build() {
            return ProfileDefinitionParams.create(this.ttl, this.protocol, this.port, this.path, this.lb, this.endpoints);
        }

        public Builder fromImageParams(ProfileDefinitionParams in) {
            return this.ttl(in.ttl()).protocol(in.protocol()).port(in.port()).path(in.path()).lb(in.lb()).endpoints(in.endpoints());
        }
    }
}

