/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class RoleToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Role role = (Role)Role.class.cast(input);
        try {
            XMLBuilder builder = XMLBuilder.create((String)"PersistentVMRole", (String)"http://schemas.microsoft.com/windowsazure");
            builder.e("RoleName").t(role.roleName()).up().e("RoleType").t(role.roleType()).up();
            XMLBuilder configSetsBuilder = builder.e("ConfigurationSets");
            if (!role.configurationSets().isEmpty()) {
                for (Role.ConfigurationSet configurationSet : role.configurationSets()) {
                    XMLBuilder configBuilder = configSetsBuilder.e("ConfigurationSet");
                    configBuilder.e("ConfigurationSetType").t(configurationSet.configurationSetType()).up();
                    XMLBuilder inputEndpoints = configBuilder.e("InputEndpoints");
                    for (Role.ConfigurationSet.InputEndpoint endpoint : configurationSet.inputEndpoints()) {
                        XMLBuilder inputBuilder = inputEndpoints.e("InputEndpoint");
                        inputBuilder.e("LocalPort").t(Integer.toString(endpoint.localPort())).up().e("Name").t(endpoint.name()).up().e("Port").t(Integer.toString(endpoint.port())).up().e("Protocol").t(endpoint.protocol().toLowerCase()).up().up();
                    }
                    XMLBuilder subnetNames = configBuilder.e("SubnetNames");
                    if (!configurationSet.subnetNames().isEmpty()) {
                        for (Role.ConfigurationSet.SubnetName subnetName : configurationSet.subnetNames()) {
                            subnetNames.e("SubnetName").t(subnetName.name()).up();
                        }
                    }
                    if (configurationSet.networkSecurityGroup() == null || configurationSet.networkSecurityGroup().isEmpty()) continue;
                    configBuilder.e("NetworkSecurityGroup").t(configurationSet.networkSecurityGroup()).up();
                }
            }
            builder.e("DataVirtualHardDisks").up().e("OSVirtualHardDisk").e("HostCaching").t(role.osVirtualHardDisk().hostCaching()).up().e("DiskName").t(role.osVirtualHardDisk().diskName()).up().e("MediaLink").t(role.osVirtualHardDisk().mediaLink().toString()).up().e("SourceImageName").t(role.osVirtualHardDisk().sourceImageName()).up().e("OS").t(role.osVirtualHardDisk().os().toString()).up().up().e("RoleSize").t(role.roleSize().getText());
            if (role.provisionGuestAgent() != null) {
                builder.e("ProvisionGuestAgent").t(role.provisionGuestAgent().toString()).up();
            }
            return (R)((HttpRequest.Builder)request.toBuilder().payload(builder.asString())).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

