/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.location.MachineDetails;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.location.PortSupplier;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.ConfigUtils;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.location.AbstractMachineLocation;
import org.apache.brooklyn.core.location.BasicMachineDetails;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.mgmt.internal.LocalLocationManager;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.ssh.SshException;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.internal.ssh.sshj.SshjTool;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.internal.ExecWithLoggingHelpers;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.KeyTransformingLoadingCache;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.pool.BasicPool;
import org.apache.brooklyn.util.pool.Pool;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.stream.KnownSizeInputStream;
import org.apache.brooklyn.util.stream.ReaderInputStream;
import org.apache.brooklyn.util.stream.StreamGobbler;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshMachineLocation
extends AbstractMachineLocation
implements MachineLocation,
PortSupplier,
WithMutexes,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SshMachineLocation.class);
    private static final Logger logSsh = LoggerFactory.getLogger((String)"org.apache.brooklyn.SSH");
    private static final int SSHABLE_CONNECT_TIMEOUT = (int)Duration.minutes((Number)2).toMilliseconds();
    public static final ConfigKey<String> SSH_TOOL_CLASS = ConfigKeys.newConfigKeyWithPrefixRemoved("brooklyn.ssh.config.", (ConfigKey)Preconditions.checkNotNull(BrooklynConfigKeys.SSH_TOOL_CLASS, (Object)"static final initializer classload ordering problem"));
    public static final String SSH_TOOL_CLASS_PROPERTIES_PREFIX = SSH_TOOL_CLASS.getName() + ".";
    public static final ConfigKey<Duration> SSH_CACHE_EXPIRY_DURATION = ConfigKeys.newConfigKey(Duration.class, "sshCacheExpiryDuration", "Expiry time for unused cached ssh connections", Duration.FIVE_MINUTES);
    public static final ConfigKey<Iterable<String>> PRIVATE_ADDRESSES = ConfigKeys.newConfigKey(new TypeToken<Iterable<String>>(){}, "privateAddresses", "Private addresses of this machine, e.g. those within the private network", null);
    public static final ConfigKey<Map<Integer, String>> TCP_PORT_MAPPINGS = ConfigKeys.newConfigKey(new TypeToken<Map<Integer, String>>(){}, "tcpPortMappings", "NAT'ed ports, giving the mapping from private TCP port to a public host:port", null);
    @SetFromFlag
    protected String user;
    @SetFromFlag(nullable=false)
    protected InetAddress address;
    @SetFromFlag
    private Set<Integer> usedPorts;
    public static final ConfigKey<String> SSH_HOST = BrooklynConfigKeys.SSH_CONFIG_HOST;
    public static final ConfigKey<Integer> SSH_PORT = BrooklynConfigKeys.SSH_CONFIG_PORT;
    public static final ConfigKey<String> SSH_EXECUTABLE = ConfigKeys.newStringConfigKey("sshExecutable", "Allows an `ssh` executable file to be specified, to be used in place of the default (programmatic) java ssh client");
    public static final ConfigKey<String> SCP_EXECUTABLE = ConfigKeys.newStringConfigKey("scpExecutable", "Allows an `scp` executable file to be specified, to be used in place of the default (programmatic) java ssh client");
    public static final ConfigKey<String> PASSWORD = SshTool.PROP_PASSWORD;
    public static final ConfigKey<String> PRIVATE_KEY_FILE = SshTool.PROP_PRIVATE_KEY_FILE;
    public static final ConfigKey<String> PRIVATE_KEY_DATA = SshTool.PROP_PRIVATE_KEY_DATA;
    public static final ConfigKey<String> PRIVATE_KEY_PASSPHRASE = SshTool.PROP_PRIVATE_KEY_PASSPHRASE;
    public static final ConfigKey<String> SCRIPT_DIR = ConfigKeys.newStringConfigKey("scriptDir", "directory where scripts should be placed and executed on the SSH target machine");
    public static final ConfigKey<Map<String, Object>> SSH_ENV_MAP = new MapConfigKey<Object>(Object.class, "env", "environment variables to pass to the remote SSH shell session");
    public static final ConfigKey<Boolean> ALLOCATE_PTY = SshTool.PROP_ALLOCATE_PTY;
    public static final ConfigKey<OutputStream> STDOUT = new BasicConfigKey<OutputStream>(OutputStream.class, "out");
    public static final ConfigKey<OutputStream> STDERR = new BasicConfigKey<OutputStream>(OutputStream.class, "err");
    public static final ConfigKey<Boolean> NO_STDOUT_LOGGING = ConfigKeys.newBooleanConfigKey("noStdoutLogging", "whether to disable logging of stdout from SSH commands (e.g. for verbose commands)", false);
    public static final ConfigKey<Boolean> NO_STDERR_LOGGING = ConfigKeys.newBooleanConfigKey("noStderrLogging", "whether to disable logging of stderr from SSH commands (e.g. for verbose commands)", false);
    public static final ConfigKey<String> LOG_PREFIX = ConfigKeys.newStringConfigKey("logPrefix");
    public static final ConfigKey<String> LOCAL_TEMP_DIR = SshTool.PROP_LOCAL_TEMP_DIR;
    public static final ConfigKey<Boolean> CLOSE_CONNECTION = ConfigKeys.newBooleanConfigKey("close", "Close the SSH connection after use", false);
    public static final ConfigKey<String> UNIQUE_ID = ConfigKeys.newStringConfigKey("unique", "Unique ID for the SSH connection");
    public static final Set<ConfigKey<?>> REUSABLE_SSH_PROPS = ImmutableSet.of(STDOUT, STDERR, SCRIPT_DIR, CLOSE_CONNECTION, (Object)SshTool.PROP_SCRIPT_HEADER, SshTool.PROP_PERMISSIONS, (Object[])new ConfigKey[]{SshTool.PROP_LAST_MODIFICATION_DATE, SshTool.PROP_LAST_ACCESS_DATE, SshTool.PROP_OWNER_UID, SshTool.PROP_SSH_RETRY_DELAY});
    public static final Set<ConfigKey.HasConfigKey<?>> ALL_SSH_CONFIG_KEYS = ImmutableSet.builder().addAll(ConfigUtils.getStaticKeysOnClass(SshMachineLocation.class)).addAll(ConfigUtils.getStaticKeysOnClass(SshTool.class)).build();
    public static final Set<String> ALL_SSH_CONFIG_KEY_NAMES = ImmutableSet.copyOf((Iterable)Iterables.transform(ALL_SSH_CONFIG_KEYS, (Function)new Function<ConfigKey.HasConfigKey<?>, String>(){

        public String apply(ConfigKey.HasConfigKey<?> input) {
            return input.getConfigKey().getName();
        }
    }));
    @Beta
    public static final Set<ConfigKey<?>> SSH_CONFIG_GIVEN_TO_PROPS = ImmutableSet.of(SCRIPT_DIR);
    private Task<?> cleanupTask;
    @Nullable
    private transient LoadingCache<Map<String, ?>, Pool<SshTool>> sshPoolCacheOrNull;
    private volatile transient boolean loggedLegcySshToolClassConfig;
    private final transient Object poolCacheMutex = new Object();
    protected boolean previouslyConnected = false;

    public SshMachineLocation() {
        this((Map<?, ?>)MutableMap.of());
    }

    public SshMachineLocation(Map<?, ?> properties) {
        super(properties);
        this.usedPorts = this.usedPorts != null ? Sets.newLinkedHashSet(this.usedPorts) : Sets.newLinkedHashSet();
    }

    @Override
    public void init() {
        super.init();
        Map<Integer, String> tcpPortMappings = this.getConfig(TCP_PORT_MAPPINGS);
        if (tcpPortMappings != null) {
            PortForwardManager pfm = (PortForwardManager)this.getManagementContext().getLocationRegistry().getLocationManaged("portForwardManager(scope=global)");
            for (Map.Entry<Integer, String> entry : tcpPortMappings.entrySet()) {
                int targetPort = entry.getKey();
                HostAndPort publicEndpoint = HostAndPort.fromString((String)entry.getValue());
                if (!publicEndpoint.hasPort()) {
                    throw new IllegalArgumentException("Invalid portMapping ('" + entry.getValue() + "') for port " + targetPort + " in machine " + this);
                }
                pfm.associate(publicEndpoint.getHostText(), publicEndpoint, this, targetPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private LoadingCache<Map<String, ?>, Pool<SshTool>> getSshPoolCache() {
        Object object = this.poolCacheMutex;
        synchronized (object) {
            if (this.sshPoolCacheOrNull == null) {
                this.sshPoolCacheOrNull = this.buildSshToolPoolCacheLoader();
                this.addSshPoolCacheCleanupTask();
            }
        }
        return this.sshPoolCacheOrNull;
    }

    private LoadingCache<Map<String, ?>, Pool<SshTool>> buildSshToolPoolCacheLoader() {
        Duration expiryDuration = this.getConfig(SSH_CACHE_EXPIRY_DURATION);
        LoadingCache delegate = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(expiryDuration.toMilliseconds(), TimeUnit.MILLISECONDS).recordStats().removalListener(new RemovalListener<Map<String, ?>, Pool<SshTool>>(){

            public void onRemoval(RemovalNotification<Map<String, ?>, Pool<SshTool>> notification) {
                block6: {
                    Pool removed = (Pool)notification.getValue();
                    if (removed == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Pool evicted from SshTool cache is null so we can't call pool.close(). It's probably already been garbage collected. Eviction cause: {} ", (Object)notification.getCause().name());
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} evicted from SshTool cache. Eviction cause: {}", (Object)removed, (Object)notification.getCause().name());
                        }
                        try {
                            removed.close();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block6;
                            LOG.debug("Exception closing " + removed, (Throwable)e);
                        }
                    }
                }
            }
        }).build(new CacheLoader<Map<String, ?>, Pool<SshTool>>(){

            public Pool<SshTool> load(Map<String, ?> properties) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} building ssh pool for {} with properties: {}", new Object[]{this, SshMachineLocation.this.getSshHostAndPort(), Sanitizer.sanitize(properties)});
                }
                return SshMachineLocation.this.buildPool(properties);
            }
        });
        ImmutableSet reusableSshProperties = ImmutableSet.copyOf((Iterable)Iterables.transform(REUSABLE_SSH_PROPS, (Function)new Function<ConfigKey<?>, String>(){

            public String apply(ConfigKey<?> input) {
                return input.getName();
            }
        }));
        return new KeyTransformingLoadingCache.KeyTransformingSameTypeLoadingCache(delegate, new Function<Map<String, ?>, Map<String, ?>>((Set)reusableSshProperties){
            final /* synthetic */ Set val$reusableSshProperties;
            {
                this.val$reusableSshProperties = set;
            }

            public Map<String, ?> apply(@Nullable Map<String, ?> input) {
                HashMap copy = new HashMap(input);
                copy.keySet().removeAll(this.val$reusableSshProperties);
                return copy;
            }
        });
    }

    private BasicPool<SshTool> buildPool(final Map<String, ?> properties) {
        return BasicPool.builder().name(this.getDisplayName() + "@" + this.address + ":" + this.getPort() + (this.config().getRaw(SSH_HOST).isPresent() ? "(" + this.getConfig(SSH_HOST) + ":" + this.getPort() + ")" : "") + ":hash" + System.identityHashCode(this)).supplier((Supplier)new Supplier<SshTool>(){

            public SshTool get() {
                return SshMachineLocation.this.connectSsh(properties);
            }
        }).viabilityChecker((Predicate)new Predicate<SshTool>(){

            public boolean apply(SshTool input) {
                return input != null && input.isConnected();
            }
        }).closer((Function)new Function<SshTool, Void>(){

            public Void apply(SshTool input) {
                block3: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} closing pool for {}", (Object)this, (Object)input);
                    }
                    try {
                        input.disconnect();
                    }
                    catch (Exception e) {
                        if (!logSsh.isDebugEnabled()) break block3;
                        logSsh.debug("On machine " + SshMachineLocation.this + ", ssh-disconnect failed", (Throwable)e);
                    }
                }
                return null;
            }
        }).build();
    }

    @Override
    public SshMachineLocation configure(Map<?, ?> properties) {
        boolean deferConstructionChecks;
        super.configure((Map)properties);
        boolean bl = deferConstructionChecks = properties.containsKey("deferConstructionChecks") && TypeCoercions.coerce(properties.get("deferConstructionChecks"), Boolean.class) != false;
        if (!deferConstructionChecks && this.getDisplayName() == null) {
            this.setDisplayName((JavaGroovyEquivalents.groovyTruth((String)this.user) ? this.user + "@" : "") + this.address.getHostName());
        }
        return this;
    }

    protected void addSshPoolCacheCleanupTask() {
        if (this.cleanupTask != null && !this.cleanupTask.isDone()) {
            return;
        }
        if (this.getManagementContext() == null || this.getManagementContext().getExecutionManager() == null) {
            LOG.debug("No management context for " + this + "; ssh-pool cache will only be closed when machine is closed");
            return;
        }
        if (Boolean.TRUE.equals(this.config().get(LocalLocationManager.CREATE_UNMANAGED))) {
            LOG.debug("Create-unmanaged for " + this + "; no explicit cleanup task; ssh-pool cache will only be closed when machine is closed");
            return;
        }
        Callable cleanupTaskFactory = new Callable<Task<?>>(){

            @Override
            public Task<Void> call() {
                return Tasks.builder().dynamic(false).tag("TRANSIENT").displayName("ssh-location cache cleaner").body(new Callable<Void>(){

                    @Override
                    public Void call() {
                        try {
                            LoadingCache sshPoolCacheOrNullRef = SshMachineLocation.this.sshPoolCacheOrNull;
                            Task cleanupTaskRef = SshMachineLocation.this.cleanupTask;
                            if (sshPoolCacheOrNullRef != null) {
                                sshPoolCacheOrNullRef.cleanUp();
                            }
                            if (!SshMachineLocation.this.isManaged()) {
                                if (sshPoolCacheOrNullRef != null) {
                                    sshPoolCacheOrNullRef.invalidateAll();
                                }
                                if (cleanupTaskRef != null) {
                                    cleanupTaskRef.cancel(false);
                                }
                                SshMachineLocation.this.sshPoolCacheOrNull = null;
                            }
                            return null;
                        }
                        catch (Exception e) {
                            LOG.warn("Problem cleaning up ssh-pool-cache", (Throwable)e);
                            return null;
                        }
                        catch (Throwable t) {
                            LOG.warn("Problem cleaning up ssh-pool-cache (rethrowing)", t);
                            throw Exceptions.propagate((Throwable)t);
                        }
                    }
                }).build();
            }
        };
        Duration expiryDuration = this.getConfig(SSH_CACHE_EXPIRY_DURATION);
        this.cleanupTask = this.getManagementContext().getExecutionManager().submit((TaskAdaptable)ScheduledTask.builder(cleanupTaskFactory).displayName("scheduled:[ssh-location cache cleaner]").period(expiryDuration).delay(expiryDuration).build());
    }

    @Override
    public void close() throws IOException {
        LoadingCache<Map<String, ?>, Pool<SshTool>> sshPoolCacheOrNullRef = this.sshPoolCacheOrNull;
        Task<?> cleanupTaskRef = this.cleanupTask;
        if (sshPoolCacheOrNullRef != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} invalidating all entries in ssh pool cache. Final stats: {}", (Object)this, (Object)sshPoolCacheOrNullRef.stats());
            }
            sshPoolCacheOrNullRef.invalidateAll();
        }
        if (cleanupTaskRef != null) {
            cleanupTaskRef.cancel(false);
        }
        this.cleanupTask = null;
        this.sshPoolCacheOrNull = null;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getHostname() {
        String hostname = this.address.getHostName();
        return hostname == null || hostname.equals(this.address.getHostAddress()) ? null : hostname;
    }

    public Set<String> getPublicAddresses() {
        return ImmutableSet.of((Object)this.address.getHostAddress());
    }

    public Set<String> getPrivateAddresses() {
        Iterable<String> result = this.getConfig(PRIVATE_ADDRESSES);
        return result == null ? ImmutableSet.of() : ImmutableSet.copyOf(result);
    }

    public HostAndPort getSshHostAndPort() {
        String host = this.getConfig(SSH_HOST);
        if (host == null || Strings.isEmpty((CharSequence)host)) {
            host = this.address.getHostName();
        }
        Integer port = this.getPort();
        return HostAndPort.fromParts((String)host, (int)port);
    }

    public String getUser() {
        if (!JavaGroovyEquivalents.groovyTruth((String)this.user)) {
            if (this.config().getLocalRaw(SshTool.PROP_USER).isPresent()) {
                LOG.warn("User configuration for " + this + " set after deployment; deprecated behaviour may not be supported in future versions");
            }
            return this.getConfig(SshTool.PROP_USER);
        }
        return this.user;
    }

    public int getPort() {
        Maybe<Object> raw = this.config().getRaw(SshTool.PROP_PORT);
        if (raw.orNull() == null && this.config().getRaw(SSH_PORT).orNull() != null) {
            return (Integer)this.config().get(SSH_PORT);
        }
        Integer result = (Integer)this.config().get(SshTool.PROP_PORT);
        return result != null ? result.intValue() : ((Integer)SshTool.PROP_PORT.getDefaultValue()).intValue();
    }

    protected <T> T execSsh(Map<String, ?> props, final Function<ShellTool, T> task) {
        final LoadingCache<Map<String, ?>, Pool<SshTool>> sshPoolCache = this.getSshPoolCache();
        Pool pool = (Pool)sshPoolCache.getUnchecked(props);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} execSsh got pool: {}", (Object)this, (Object)pool);
        }
        if (JavaGroovyEquivalents.groovyTruth(props.get(CLOSE_CONNECTION.getName()))) {
            Function close = new Function<SshTool, T>(){

                public T apply(SshTool input) {
                    Object result = task.apply((Object)input);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} invalidating all sshPoolCache entries: {}", (Object)SshMachineLocation.this, (Object)sshPoolCache.stats().toString());
                    }
                    sshPoolCache.invalidateAll();
                    sshPoolCache.cleanUp();
                    return result;
                }
            };
            return (T)pool.exec(close);
        }
        return (T)pool.exec(task);
    }

    protected SshTool connectSsh() {
        return this.connectSsh((Map<?, ?>)ImmutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SshTool connectSsh(Map<?, ?> props) {
        try {
            if (!JavaGroovyEquivalents.groovyTruth((String)this.user)) {
                String newUser = this.getUser();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("For " + this + ", setting user in connectSsh: oldUser=" + this.user + "; newUser=" + newUser);
                }
                this.user = newUser;
            }
            ConfigBag args = new ConfigBag().configure(SshTool.PROP_USER, this.user).configure(SshTool.PROP_HOST, this.address.getHostName());
            for (Map.Entry<ConfigKey<?>, ?> entry : this.config().getBag().getAllConfigAsConfigKeyMap().entrySet()) {
                boolean include = false;
                String keyName = entry.getKey().getName();
                if (keyName.startsWith("brooklyn.ssh.config.")) {
                    keyName = Strings.removeFromStart((String)keyName, (String)"brooklyn.ssh.config.");
                    include = true;
                }
                if (keyName.startsWith(SSH_TOOL_CLASS_PROPERTIES_PREFIX)) {
                    keyName = Strings.removeFromStart((String)keyName, (String)SSH_TOOL_CLASS_PROPERTIES_PREFIX);
                    include = true;
                }
                if (ALL_SSH_CONFIG_KEY_NAMES.contains(keyName)) {
                    include = true;
                }
                if (!include) continue;
                args.putStringKey(keyName, this.config().get(entry.getKey()));
            }
            args.putAll(props);
            if (LOG.isTraceEnabled()) {
                LOG.trace("creating ssh session for " + Sanitizer.sanitize(args));
            }
            if (!this.user.equals(args.get(SshTool.PROP_USER))) {
                LOG.warn("User mismatch configuring ssh for " + this + ": preferring user " + args.get(SshTool.PROP_USER) + " over " + this.user);
                this.user = args.get(SshTool.PROP_USER);
            }
            String sshToolClass = args.get(SSH_TOOL_CLASS);
            String legacySshToolClass = args.get(SshTool.PROP_TOOL_CLASS);
            if (Strings.isNonBlank((CharSequence)legacySshToolClass)) {
                String msg;
                if (Strings.isNonBlank((CharSequence)sshToolClass)) {
                    msg = "Ignoring deprecated config " + SshTool.PROP_TOOL_CLASS.getName() + "=" + legacySshToolClass + ", preferring " + SSH_TOOL_CLASS.getName() + "=" + sshToolClass + " for " + this;
                } else {
                    sshToolClass = legacySshToolClass;
                    msg = "Using deprecated config " + SshTool.PROP_TOOL_CLASS.getName() + "=" + legacySshToolClass + ", preferring " + SSH_TOOL_CLASS.getName() + "=" + sshToolClass + " for " + this;
                }
                if (!this.loggedLegcySshToolClassConfig) {
                    LOG.warn(msg);
                    this.loggedLegcySshToolClassConfig = true;
                }
            }
            if (sshToolClass == null) {
                sshToolClass = SshjTool.class.getName();
            }
            SshTool ssh = (SshTool)new ClassLoaderUtils((Object)this, this.getManagementContext()).loadClass(sshToolClass).getConstructor(Map.class).newInstance(args.getAllConfig());
            if (LOG.isTraceEnabled()) {
                LOG.trace("using ssh-tool {} (of type {}); props ", (Object)ssh, (Object)sshToolClass);
            }
            Tasks.setBlockingDetails("Opening ssh connection");
            try {
                ssh.connect();
            }
            finally {
                Tasks.setBlockingDetails(null);
            }
            this.previouslyConnected = true;
            return ssh;
        }
        catch (Exception e) {
            if (this.previouslyConnected) {
                throw Throwables.propagate((Throwable)e);
            }
            String rootCause = Throwables.getRootCause((Throwable)e).getMessage();
            throw new IllegalStateException("Cannot establish ssh connection to " + this.user + " @ " + this + (rootCause != null && !rootCause.isEmpty() ? " (" + rootCause + ")" : "") + ". \nEnsure that passwordless and passphraseless ssh access is enabled using standard keys from ~/.ssh or as configured in brooklyn.properties. Check that the target host is accessible, that credentials are correct (location and permissions if using a key), that the SFTP subsystem is available on the remote side, and that there is sufficient random noise in /dev/random on both ends. To debug less common causes, see the original error in the trace or log, and/or enable 'net.schmizz' (sshj) logging.", e);
        }
    }

    public int execCommands(String summaryForLogging, List<String> commands) {
        return this.execCommands((Map<String, ?>)MutableMap.of(), summaryForLogging, commands, (Map<String, ?>)MutableMap.of());
    }

    public int execCommands(Map<String, ?> props, String summaryForLogging, List<String> commands) {
        return this.execCommands(props, summaryForLogging, commands, (Map<String, ?>)MutableMap.of());
    }

    public int execCommands(String summaryForLogging, List<String> commands, Map<String, ?> env) {
        return this.execCommands((Map<String, ?>)MutableMap.of(), summaryForLogging, commands, env);
    }

    public int execCommands(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        return this.newExecWithLoggingHelpers().execCommands(this.augmentPropertiesWithSshConfigGivenToProps(props), summaryForLogging, commands, env);
    }

    public int execScript(String summaryForLogging, List<String> commands) {
        return this.execScript((Map<String, ?>)MutableMap.of(), summaryForLogging, commands, (Map<String, ?>)MutableMap.of());
    }

    public int execScript(Map<String, ?> props, String summaryForLogging, List<String> commands) {
        return this.execScript(props, summaryForLogging, commands, (Map<String, ?>)MutableMap.of());
    }

    public int execScript(String summaryForLogging, List<String> commands, Map<String, ?> env) {
        return this.execScript((Map<String, ?>)MutableMap.of(), summaryForLogging, commands, env);
    }

    public int execScript(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        return this.newExecWithLoggingHelpers().execScript(this.augmentPropertiesWithSshConfigGivenToProps(props), summaryForLogging, commands, env);
    }

    private Map<String, Object> augmentPropertiesWithSshConfigGivenToProps(Map<String, ?> props) {
        HashMap augmentedProps = Maps.newHashMap(props);
        for (ConfigKey<?> config : SSH_CONFIG_GIVEN_TO_PROPS) {
            if (augmentedProps.containsKey(config.getName()) || !this.config().getRaw(config).isPresent()) continue;
            augmentedProps.put(config.getName(), this.getConfig(config));
        }
        return augmentedProps;
    }

    protected ExecWithLoggingHelpers newExecWithLoggingHelpers() {
        return new ExecWithLoggingHelpers("SSH"){

            @Override
            protected <T> T execWithTool(MutableMap<String, Object> props, Function<ShellTool, T> function) {
                return SshMachineLocation.this.execSsh((Map<String, ?>)props, function);
            }

            @Override
            protected void preExecChecks() {
                Preconditions.checkNotNull((Object)SshMachineLocation.this.address, (Object)"host address must be specified for ssh");
            }

            @Override
            protected String constructDefaultLoggingPrefix(ConfigBag execFlags) {
                String hostname = SshMachineLocation.this.getAddress().getHostName();
                Integer port = execFlags.peek(SshTool.PROP_PORT);
                if (port == null) {
                    port = SshMachineLocation.this.getConfig(ConfigUtils.prefixedKey("brooklyn.ssh.config.", SshTool.PROP_PORT));
                }
                return (SshMachineLocation.this.user != null ? SshMachineLocation.this.user + "@" : "") + hostname + (port != null ? ":" + port : "");
            }

            @Override
            protected String getTargetName() {
                return "" + SshMachineLocation.this;
            }
        }.logger(logSsh);
    }

    public int copyTo(File src, File destination) {
        return this.copyTo((Map<String, ?>)MutableMap.of(), src, destination);
    }

    public int copyTo(Map<String, ?> props, File src, File destination) {
        return this.copyTo(props, src, destination.getPath());
    }

    public int copyTo(File src, String destination) {
        return this.copyTo((Map<String, ?>)MutableMap.of(), src, destination);
    }

    public int copyTo(Map<String, ?> props, File src, String destination) {
        Preconditions.checkNotNull((Object)this.address, (Object)"Host address must be specified for scp");
        Preconditions.checkArgument((boolean)src.exists(), (String)"File %s must exist for scp", (Object[])new Object[]{src.getPath()});
        try {
            return this.copyTo(props, new FileInputStream(src), src.length(), destination);
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public int copyTo(Reader src, String destination) {
        return this.copyTo((Map<String, ?>)MutableMap.of(), src, destination);
    }

    public int copyTo(Map<String, ?> props, Reader src, String destination) {
        return this.copyTo(props, (InputStream)new ReaderInputStream(src), destination);
    }

    public int copyTo(InputStream src, String destination) {
        return this.copyTo((Map<String, ?>)MutableMap.of(), src, destination);
    }

    public int copyTo(InputStream src, long filesize, String destination) {
        return this.copyTo((Map<String, ?>)MutableMap.of(), src, filesize, destination);
    }

    public int copyTo(final Map<String, ?> props, final InputStream src, final long filesize, final String destination) {
        if (filesize == -1L) {
            return this.copyTo(props, src, destination);
        }
        return this.execSsh(props, new Function<ShellTool, Integer>(){

            public Integer apply(ShellTool ssh) {
                return ((SshTool)ssh).copyToServer(props, (InputStream)new KnownSizeInputStream(src, filesize), destination);
            }
        });
    }

    public int copyTo(final Map<String, ?> props, final InputStream src, final String destination) {
        return this.execSsh(props, new Function<ShellTool, Integer>(){

            public Integer apply(ShellTool ssh) {
                return ((SshTool)ssh).copyToServer(props, src, destination);
            }
        });
    }

    public int copyFrom(String remote, String local) {
        return this.copyFrom((Map<String, ?>)MutableMap.of(), remote, local);
    }

    public int copyFrom(final Map<String, ?> props, final String remote, final String local) {
        return this.execSsh(props, new Function<ShellTool, Integer>(){

            public Integer apply(ShellTool ssh) {
                return ((SshTool)ssh).copyFromServer(props, remote, new File(local));
            }
        });
    }

    public int installTo(String url, String destPath) {
        return this.installTo((Map<String, ?>)MutableMap.of(), url, destPath);
    }

    public int installTo(Map<String, ?> props, String url, String destPath) {
        return this.installTo(ResourceUtils.create(this), props, url, destPath);
    }

    public int installTo(ResourceUtils loader, String url, String destPath) {
        return this.installTo(loader, (Map<String, ?>)MutableMap.of(), url, destPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int installTo(ResourceUtils utils, Map<String, ?> props, String url, String destPath) {
        LOG.debug("installing {} to {} on {}, attempting remote curl", new Object[]{url, destPath, this});
        try {
            PipedInputStream insO = new PipedInputStream();
            PipedOutputStream outO = new PipedOutputStream(insO);
            PipedInputStream insE = new PipedInputStream();
            PipedOutputStream outE = new PipedOutputStream(insE);
            StreamGobbler sgsO = new StreamGobbler((InputStream)insO, null, LOG);
            sgsO.setLogPrefix("[curl @ " + this.address + ":stdout] ").start();
            StreamGobbler sgsE = new StreamGobbler((InputStream)insE, null, LOG);
            sgsE.setLogPrefix("[curl @ " + this.address + ":stdout] ").start();
            MutableMap sshProps = MutableMap.builder().putAll(props).put((Object)"out", (Object)outO).put((Object)"err", (Object)outE).build();
            int result = this.execScript((Map<String, ?>)sshProps, "copying remote resource " + url + " to server", (List<String>)ImmutableList.of((Object)BashCommands.INSTALL_CURL, (Object)("mkdir -p `dirname '" + destPath + "'`"), (Object)("curl " + url + " -L --silent --insecure --show-error --fail --connect-timeout 60 --max-time 600 --retry 5 -o '" + destPath + "'")));
            sgsO.close();
            sgsE.close();
            if (result != 0) {
                LOG.debug("installing {} to {} on {}, curl failed, attempting local fetch and copy", new Object[]{url, destPath, this});
                try {
                    Tasks.setBlockingDetails("retrieving resource " + url + " for copying across");
                    InputStream stream = utils.getResourceFromUrl(url);
                    Tasks.setBlockingDetails("copying resource " + url + " to server");
                    result = this.copyTo(props, stream, destPath);
                }
                finally {
                    Tasks.setBlockingDetails(null);
                }
            }
            if (result == 0) {
                LOG.debug("installing {} complete; {} on {}", new Object[]{url, destPath, this});
            } else {
                LOG.warn("installing {} failed; {} on {}: {}", new Object[]{url, destPath, this, result});
            }
            return result;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "SshMachineLocation[" + this.getDisplayName() + ":" + this.user + "@" + this.address + ":" + this.getPort() + "(id=" + this.getId() + ")]";
    }

    @Override
    public String toVerboseString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("user", (Object)this.getUser()).add("address", (Object)this.getAddress()).add("port", this.getPort()).add("parentLocation", (Object)this.getParent()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean obtainSpecificPort(int portNumber) {
        Set<Integer> set = this.usedPorts;
        synchronized (set) {
            if (this.usedPorts.contains(portNumber)) {
                return false;
            }
            this.usedPorts.add(portNumber);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int obtainPort(PortRange range) {
        Set<Integer> set = this.usedPorts;
        synchronized (set) {
            Iterator iterator = range.iterator();
            while (iterator.hasNext()) {
                int p = (Integer)iterator.next();
                if (!this.obtainSpecificPort(p)) continue;
                return p;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("unable to find port in {} on {}; returning -1", (Object)range, (Object)this);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePort(int portNumber) {
        Set<Integer> set = this.usedPorts;
        synchronized (set) {
            this.usedPorts.remove(portNumber);
        }
    }

    public boolean isSshable() {
        String cmd = "date";
        try {
            try {
                Socket s = new Socket();
                s.connect(new InetSocketAddress(this.getAddress(), this.getPort()), SSHABLE_CONNECT_TIMEOUT);
                s.close();
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("" + this + " not [yet] reachable (socket " + this.getAddress() + ":" + this.getPort() + "): " + e);
                }
                return false;
            }
            int result = this.execCommands((Map<String, ?>)MutableMap.of(), "isSshable", (List<String>)ImmutableList.of((Object)cmd));
            if (result == 0) {
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not reachable: {}, executing `{}`, exit code {}", new Object[]{this, cmd, result});
            }
            return false;
        }
        catch (SshException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exception checking if " + this + " is reachable; assuming not", (Throwable)e);
            }
            return false;
        }
        catch (IllegalStateException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exception checking if " + this + " is reachable; assuming not", (Throwable)e);
            }
            return false;
        }
        catch (RuntimeException e) {
            if (Exceptions.getFirstThrowableOfType((Throwable)e, IOException.class) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception checking if " + this + " is reachable; assuming not", (Throwable)e);
                }
                return false;
            }
            throw e;
        }
    }

    @Override
    protected MachineDetails detectMachineDetails() {
        Tasks.setBlockingDetails("Waiting for machine details");
        try {
            BasicMachineDetails basicMachineDetails = BasicMachineDetails.forSshMachineLocationLive(this);
            return basicMachineDetails;
        }
        finally {
            Tasks.resetBlockingDetails();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getSshPoolCache();
    }

    public KeyPair findKeyPair() {
        LocationConfigUtils.OsCredential creds = LocationConfigUtils.getOsCredential(this.config().getBag());
        if (creds.hasKey()) {
            String data = creds.getPrivateKeyData();
            return SecureKeys.readPem(data.getBytes(), this.getConfig(SshTool.PROP_PRIVATE_KEY_PASSPHRASE));
        }
        return null;
    }

    public String findPassword() {
        return (String)this.getConfig(SshTool.PROP_PASSWORD);
    }

    @Override
    @Deprecated
    public void acquireMutex(String mutexId, String description) {
        this.mutexes().acquireMutex(mutexId, description);
    }

    @Override
    @Deprecated
    public boolean tryAcquireMutex(String mutexId, String description) {
        return this.mutexes().tryAcquireMutex(mutexId, description);
    }

    @Override
    @Deprecated
    public void releaseMutex(String mutexId) {
        this.mutexes().releaseMutex(mutexId);
    }

    @Override
    @Deprecated
    public boolean hasMutex(String mutexId) {
        return this.mutexes().hasMutex(mutexId);
    }
}

