/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.action;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInitializers;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.config.ResolvingConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.DurationPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractScheduledEffectorPolicy
extends AbstractPolicy
implements Runnable,
SensorEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractScheduledEffectorPolicy.class);
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String NOW = "now";
    public static final String IMMEDIATELY = "immediately";
    private static final DateFormat FORMATTER = SimpleDateFormat.getTimeInstance();
    public static final ConfigKey<String> EFFECTOR = ConfigKeys.builder(String.class).name("effector").description("The effector to be executed by this policy").constraint(Predicates.notNull()).build();
    public static final ConfigKey<Map<String, Object>> EFFECTOR_ARGUMENTS = ConfigKeys.builder((TypeToken)new TypeToken<Map<String, Object>>(){}).name("args").description("The effector arguments and their values").constraint(Predicates.notNull()).defaultValue((Object)ImmutableMap.of()).build();
    public static final ConfigKey<String> TIME = ConfigKeys.builder(String.class).name("time").description("An optional time when this policy should be first executed, formatted as HH:mm:ss").build();
    public static final ConfigKey<Duration> WAIT = ConfigKeys.builder(Duration.class).name("wait").description("An optional duration after which this policy should be first executed. The time config takes precedence if present").constraint(Predicates.or((Predicate)Predicates.isNull(), (Predicate)DurationPredicates.positive())).build();
    public static final ConfigKey<AttributeSensor<Boolean>> START_SENSOR = ConfigKeys.builder((TypeToken)new TypeToken<AttributeSensor<Boolean>>(){}).name("start.sensor").description("The sensor which should trigger starting the periodic execution scheduler").defaultValue((Object)Startable.SERVICE_UP).build();
    public static final ConfigKey<Boolean> RUNNING = ConfigKeys.builder(Boolean.class).name("running").description("[INTERNAL] Set if the executor has started").defaultValue((Object)Boolean.FALSE).reconfigurable(true).build();
    public static final ConfigKey<List<Long>> SCHEDULED = ConfigKeys.builder((TypeToken)new TypeToken<List<Long>>(){}).name("scheduled").description("List of all scheduled execution start times").defaultValue((Object)ImmutableList.of()).reconfigurable(true).build();
    protected AtomicBoolean running;
    protected ScheduledExecutorService executor;
    protected Effector<?> effector;

    public AbstractScheduledEffectorPolicy() {
        LOG.debug("Created new scheduled effector policy");
    }

    public void init() {
        this.setup();
    }

    public void rebind() {
        this.setup();
    }

    public void setup() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.running = new AtomicBoolean(false);
    }

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.effector = this.getEffector();
        if (Boolean.TRUE.equals(this.config().get(RUNNING))) {
            this.running.set(true);
            this.resubmitOnResume();
        }
        AttributeSensor sensor = (AttributeSensor)this.config().get(START_SENSOR);
        this.subscriptions().subscribe((Map)ImmutableMap.of((Object)"notifyOfInitialValue", (Object)true), (Entity)entity, (Sensor)sensor, (SensorEventListener)this);
    }

    public void resume() {
        super.resume();
        if (this.running.get()) {
            this.resubmitOnResume();
        }
    }

    protected List<Long> resubmitOnResume() {
        List scheduled = (List)this.config().get(SCHEDULED);
        MutableList updatedScheduled = MutableList.copyOf((Iterable)scheduled);
        for (Long when : scheduled) {
            Duration wait = Duration.millis((Number)(when - System.currentTimeMillis()));
            if (wait.isPositive()) {
                this.scheduleInExecutor(wait);
                continue;
            }
            updatedScheduled.remove(when);
        }
        this.config().set(SCHEDULED, (Object)updatedScheduled);
        return updatedScheduled;
    }

    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        if (key.isReconfigurable()) {
            return;
        }
        throw new UnsupportedOperationException("Reconfiguring key " + key.getName() + " not supported on " + this.getClass().getSimpleName());
    }

    public void destroy() {
        this.executor.shutdownNow();
        super.destroy();
    }

    public abstract void start();

    protected Effector<?> getEffector() {
        String effectorName = (String)this.config().get(EFFECTOR);
        Maybe effector = this.getEntity().getEntityType().getEffectorByName(effectorName);
        if (effector.isAbsentOrNull()) {
            throw new IllegalStateException("Cannot find effector " + effectorName + " on entity " + this.getEntity());
        }
        return (Effector)effector.get();
    }

    protected Duration getWaitUntil(String time) {
        if (time.equalsIgnoreCase(NOW) || time.equalsIgnoreCase(IMMEDIATELY)) {
            return Duration.ZERO;
        }
        try {
            Calendar now = Calendar.getInstance();
            Calendar when = Calendar.getInstance();
            Date parsed = this.parseTime(time);
            when.setTime(parsed);
            when.set(now.get(1), now.get(2), now.get(5));
            if (when.before(now)) {
                when.add(5, 1);
            }
            return Duration.millis((Number)Math.max(0L, when.getTimeInMillis() - now.getTimeInMillis()));
        }
        catch (NumberFormatException | ParseException e) {
            LOG.warn("{}: Time should be formatted as {}: {}", new Object[]{this, TIME_FORMAT, e.getMessage()});
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseTime(String time) throws ParseException {
        boolean formatted = time.contains(":");
        if (formatted) {
            DateFormat dateFormat = FORMATTER;
            synchronized (dateFormat) {
                return FORMATTER.parse(time);
            }
        }
        return new Date(Long.parseLong(time) * 1000L);
    }

    protected void schedule(Duration wait) {
        MutableList scheduled = MutableList.copyOf((Iterable)((Iterable)this.config().get(SCHEDULED)));
        scheduled.add(System.currentTimeMillis() + wait.toMilliseconds());
        this.config().set(SCHEDULED, (Object)scheduled);
        this.scheduleInExecutor(wait);
    }

    private void scheduleInExecutor(Duration wait) {
        this.executor.schedule(this, wait.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void run() {
        if (this.effector == null) {
            return;
        }
        if (!this.isRunning() || !this.getManagementContext().isRunning()) {
            return;
        }
        try {
            ConfigBag bag = ResolvingConfigBag.newInstanceExtending((ManagementContext)this.getManagementContext(), (ConfigBag)this.config().getBag());
            Map args = (Map)EntityInitializers.resolve((ConfigBag)bag, EFFECTOR_ARGUMENTS);
            LOG.debug("{}: Resolving arguments for {}: {}", new Object[]{this, this.effector.getName(), Iterables.toString(args.keySet())});
            Map resolved = (Map)Tasks.resolving((Object)args, Object.class).deep(true, Boolean.valueOf(true)).context((Entity)this.entity).get();
            LOG.debug("{}: Invoking effector on {}, {}({})", new Object[]{this, this.entity, this.effector.getName(), resolved});
            Object result = this.entity.invoke(this.effector, resolved).getUnchecked();
            LOG.debug("{}: Effector {} returned {}", new Object[]{this, this.effector.getName(), result});
        }
        catch (RuntimeInterruptedException rie) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            LOG.warn("{}: Exception running {}: {}", new Object[]{this, this.effector.getName(), t.getMessage()});
            Exceptions.propagate((Throwable)t);
        }
    }

    public void onEvent(SensorEvent<Object> event) {
        Boolean start;
        LOG.debug("{}: Got event {}", (Object)this, event);
        AttributeSensor sensor = (AttributeSensor)this.config().get(START_SENSOR);
        if (event.getSensor().getName().equals(sensor.getName()) && (start = Boolean.valueOf(Boolean.TRUE.equals(event.getValue()))).booleanValue() && this.running.compareAndSet(false, true)) {
            this.config().set(RUNNING, (Object)true);
            this.start();
        }
    }
}

