/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.DataVirtualHardDisk;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.azurecompute.domain.RoleSize;
import org.jclouds.azurecompute.xml.ConfigurationSetHandler;
import org.jclouds.azurecompute.xml.DataVirtualHardDiskHandler;
import org.jclouds.azurecompute.xml.OSVirtualHardDiskHandler;
import org.jclouds.azurecompute.xml.ResourceExtensionReferenceHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class RoleHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Role> {
    private String roleName;
    private String roleType;
    private String vmImage;
    private String mediaLocation;
    private List<Role.ConfigurationSet> configurationSets = Lists.newArrayList();
    private List<Role.ResourceExtensionReference> resourceExtensionReferences = Lists.newArrayList();
    private String availabilitySetName;
    private List<DataVirtualHardDisk> dataVirtualHardDisks = Lists.newArrayList();
    private Role.OSVirtualHardDisk osVirtualHardDisk;
    private RoleSize.Type roleSize;
    private Boolean provisionGuestAgent;
    private String defaultWinRmCertificateThumbprint;
    private boolean inConfigurationSets;
    private boolean inOSVirtualHardDisk;
    private boolean inDataVirtualHardDisks;
    private boolean inResourceExtensionReference;
    private final ConfigurationSetHandler configurationSetHandler;
    private final OSVirtualHardDiskHandler osVirtualDiskHandler;
    private final DataVirtualHardDiskHandler dataVirtualHardDiskHandler;
    private final ResourceExtensionReferenceHandler resourceExtensionReferenceHandler;
    private StringBuilder currentText = new StringBuilder();

    @Inject
    RoleHandler(ConfigurationSetHandler configurationSetHandler, OSVirtualHardDiskHandler osVirtualDiskHandler, DataVirtualHardDiskHandler dataVirtualHardDiskHandler, ResourceExtensionReferenceHandler resourceExtensionReferenceHandler) {
        this.configurationSetHandler = configurationSetHandler;
        this.osVirtualDiskHandler = osVirtualDiskHandler;
        this.dataVirtualHardDiskHandler = dataVirtualHardDiskHandler;
        this.resourceExtensionReferenceHandler = resourceExtensionReferenceHandler;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("ConfigurationSets")) {
            this.inConfigurationSets = true;
        }
        if (this.inConfigurationSets) {
            this.configurationSetHandler.startElement(uri, localName, qName, attributes);
        }
        if (qName.equals("OSVirtualHardDisk")) {
            this.inOSVirtualHardDisk = true;
        }
        if (qName.equals("DataVirtualHardDisks")) {
            this.inDataVirtualHardDisks = true;
        }
        if (this.inDataVirtualHardDisks) {
            this.dataVirtualHardDiskHandler.startElement(uri, localName, qName, attributes);
        }
        if (qName.equals("ResourceExtensionReference")) {
            this.inResourceExtensionReference = true;
        }
        if (this.inResourceExtensionReference) {
            this.resourceExtensionReferenceHandler.startElement(uri, localName, qName, attributes);
        }
    }

    private void resetState() {
        this.defaultWinRmCertificateThumbprint = null;
        this.availabilitySetName = null;
        this.mediaLocation = null;
        this.vmImage = null;
        this.roleType = null;
        this.roleName = null;
        this.configurationSets = null;
        this.osVirtualHardDisk = null;
        this.configurationSets = Lists.newArrayList();
        this.resourceExtensionReferences = Lists.newArrayList();
        this.dataVirtualHardDisks = Lists.newArrayList();
        this.roleSize = null;
        this.provisionGuestAgent = null;
    }

    public Role getResult() {
        Role result = Role.create(this.roleName, this.roleType, this.vmImage, this.mediaLocation, this.configurationSets, this.resourceExtensionReferences, this.availabilitySetName, this.dataVirtualHardDisks, this.osVirtualHardDisk, this.roleSize, this.provisionGuestAgent, this.defaultWinRmCertificateThumbprint);
        this.resetState();
        return result;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("DataVirtualHardDisks")) {
            this.inDataVirtualHardDisks = false;
        } else if (qName.equals("ConfigurationSet")) {
            this.inConfigurationSets = false;
            this.configurationSets.add(this.configurationSetHandler.getResult());
        } else if (this.inConfigurationSets) {
            this.configurationSetHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("DataVirtualHardDisks")) {
            this.inDataVirtualHardDisks = false;
            this.dataVirtualHardDisks.add(this.dataVirtualHardDiskHandler.getResult());
        } else if (this.inDataVirtualHardDisks) {
            this.dataVirtualHardDiskHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("RoleName")) {
            this.roleName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("VMImage")) {
            this.vmImage = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("MediaLocation")) {
            this.mediaLocation = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("AvailabilitySetName")) {
            this.availabilitySetName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("DefaultWinRmCertificateThumbprint")) {
            this.defaultWinRmCertificateThumbprint = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("RoleType")) {
            this.roleType = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("OSVirtualHardDisk")) {
            this.inOSVirtualHardDisk = false;
            this.osVirtualHardDisk = this.osVirtualDiskHandler.getResult();
        } else if (this.inOSVirtualHardDisk) {
            this.osVirtualDiskHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("RoleSize")) {
            this.roleSize = RoleSize.Type.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText).toUpperCase());
        } else if (qName.equals("ProvisionGuestAgent")) {
            String provisionGuestAgentString = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (provisionGuestAgentString != null) {
                this.provisionGuestAgent = Boolean.valueOf(provisionGuestAgentString);
            }
        } else if (qName.equals("ResourceExtensionReferences")) {
            this.inResourceExtensionReference = false;
        } else if (qName.equals("ResourceExtensionReference")) {
            this.resourceExtensionReferences.add(this.resourceExtensionReferenceHandler.getResult());
        } else if (this.inResourceExtensionReference) {
            this.resourceExtensionReferenceHandler.endElement(ignoredUri, ignoredName, qName);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inConfigurationSets) {
            this.configurationSetHandler.characters(ch, start, length);
        } else if (this.inOSVirtualHardDisk) {
            this.osVirtualDiskHandler.characters(ch, start, length);
        } else if (this.inResourceExtensionReference) {
            this.resourceExtensionReferenceHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

