/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import org.jclouds.azurecompute.domain.ProfileDefinition;
import org.jclouds.azurecompute.domain.ProfileDefinitionMonitor;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class ProfileDefinitionMonitorHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<ProfileDefinitionMonitor> {
    private Integer intervall;
    private Integer timeout;
    private Integer toleration;
    private ProfileDefinition.Protocol protocol;
    private Integer port;
    private String verb;
    private String path;
    private Integer expected;
    private final StringBuilder currentText = new StringBuilder();

    public ProfileDefinitionMonitor getResult() {
        ProfileDefinitionMonitor result = ProfileDefinitionMonitor.create(this.intervall, this.timeout, this.toleration, this.protocol, this.port, this.verb, this.path, this.expected);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.expected = null;
        this.port = null;
        this.toleration = null;
        this.timeout = null;
        this.intervall = null;
        this.protocol = null;
        this.path = null;
        this.verb = null;
    }

    public void startElement(String ignoredUri, String ignoredLocalName, String qName, Attributes ignoredAttributes) {
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("IntervalInSeconds")) {
            String value = this.currentText.toString().trim();
            this.intervall = value.isEmpty() ? 30 : Integer.parseInt(value);
        } else if (qName.equals("TimeoutInSeconds")) {
            String value = this.currentText.toString().trim();
            this.timeout = value.isEmpty() ? 10 : Integer.parseInt(value);
        } else if (qName.equals("ToleratedNumberOfFailures")) {
            String value = this.currentText.toString().trim();
            this.toleration = value.isEmpty() ? 3 : Integer.parseInt(value);
        } else if (qName.equals("Protocol")) {
            this.protocol = ProfileDefinition.Protocol.fromString(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Port")) {
            this.port = Integer.parseInt(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (qName.equals("Verb")) {
            String value = this.currentText.toString().trim();
            this.verb = value.isEmpty() ? "GET" : value;
        } else if (qName.equals("RelativePath")) {
            this.path = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("ExpectedStatusCode")) {
            String value = this.currentText.toString().trim();
            this.expected = value.isEmpty() ? 200 : Integer.parseInt(value);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

