/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.OSImage;
import org.jclouds.azurecompute.xml.OSImageHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public final class ListOSImagesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<OSImage>> {
    private boolean inOSImage;
    private final OSImageHandler osImageHandler;
    private final ImmutableList.Builder<OSImage> images = ImmutableList.builder();

    @Inject
    ListOSImagesHandler(OSImageHandler osImageHandler) {
        this.osImageHandler = osImageHandler;
    }

    public List<OSImage> getResult() {
        return this.images.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("OSImage")) {
            this.inOSImage = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("OSImage")) {
            this.inOSImage = false;
            this.images.add((Object)this.osImageHandler.getResult());
        } else if (this.inOSImage) {
            this.osImageHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inOSImage) {
            this.osImageHandler.characters(ch, start, length);
        }
    }
}

