/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.util.Date;
import java.util.List;
import org.jclouds.azurecompute.domain.AffinityGroup;
import org.jclouds.azurecompute.domain.ComputeCapabilities;
import org.jclouds.azurecompute.xml.ComputeCapabilitiesHandler;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class AffinityGroupHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<AffinityGroup> {
    private final StringBuilder currentText = new StringBuilder();
    private final ComputeCapabilitiesHandler computeCapabilitiesHandler;
    private String name;
    private String label;
    private String description;
    private String location;
    private final List<AffinityGroup.Capability> capabilities = Lists.newArrayList();
    private Date createdTime;
    private ComputeCapabilities computeCapabilities;
    private boolean inComputeCapabilities = false;

    @Inject
    AffinityGroupHandler(ComputeCapabilitiesHandler computeCapabilitiesHandler) {
        this.computeCapabilitiesHandler = computeCapabilitiesHandler;
    }

    public AffinityGroup getResult() {
        AffinityGroup result = AffinityGroup.create(this.name, this.label, this.description, this.location, this.capabilities, this.createdTime, this.computeCapabilities);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.name = null;
        this.label = null;
        this.description = null;
        this.location = null;
        this.capabilities.clear();
        this.createdTime = null;
        this.computeCapabilities = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ComputeCapabilities".equals(qName)) {
            this.inComputeCapabilities = true;
        } else if (this.inComputeCapabilities) {
            this.computeCapabilitiesHandler.startElement(uri, localName, qName, attributes);
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if ("Name".equals(qName)) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("Label".equals(qName)) {
            this.label = new String(BaseEncoding.base64().decode((CharSequence)SaxUtils.currentOrNull((StringBuilder)this.currentText)), Charsets.UTF_8);
        } else if ("Description".equals(qName)) {
            this.description = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("Location".equals(qName)) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("Capability".equals(qName)) {
            String capabilityText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (capabilityText != null) {
                this.capabilities.add(AffinityGroup.Capability.valueOf(capabilityText));
            }
        } else if ("CreatedTime".equals(qName)) {
            String createdTimeText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (createdTimeText != null) {
                this.createdTime = new SimpleDateFormatDateService().iso8601DateOrSecondsDateParse(createdTimeText);
            }
        } else if ("ComputeCapabilities".equals(qName)) {
            this.inComputeCapabilities = false;
            this.computeCapabilities = this.computeCapabilitiesHandler.getResult();
        } else if (this.inComputeCapabilities) {
            this.computeCapabilitiesHandler.endElement(ignoredUri, ignoredName, qName);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inComputeCapabilities) {
            this.computeCapabilitiesHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

