/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.domain.AutoValue_CreateStorageServiceParams;
import org.jclouds.azurecompute.domain.StorageService;
import org.jclouds.javax.annotation.Nullable;

public abstract class CreateStorageServiceParams {
    CreateStorageServiceParams() {
    }

    public abstract String serviceName();

    @Nullable
    public abstract String description();

    public abstract String label();

    @Nullable
    public abstract String location();

    @Nullable
    public abstract String affinityGroup();

    @Nullable
    public abstract Map<String, String> extendedProperties();

    public abstract StorageService.AccountType accountType();

    public Builder toBuilder() {
        return CreateStorageServiceParams.builder().fromCreateStorageServiceParams(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static CreateStorageServiceParams create(String serviceName, String description, String label, String location, String affinityGroup, Map<String, String> extendedProperties, StorageService.AccountType accountType) {
        return new AutoValue_CreateStorageServiceParams(serviceName, description, label, location, affinityGroup, (Map<String, String>)(extendedProperties == null ? null : ImmutableMap.copyOf(extendedProperties)), accountType);
    }

    public static final class Builder {
        private String serviceName;
        private String description;
        private String label;
        private String location;
        private String affinityGroup;
        private Map<String, String> extendedProperties;
        private StorageService.AccountType accountType;

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder affinityGroup(String affinityGroup) {
            this.affinityGroup = affinityGroup;
            return this;
        }

        public Builder extendedProperties(Map<String, String> extendedProperties) {
            this.extendedProperties = extendedProperties;
            return this;
        }

        public Builder accountType(StorageService.AccountType accountType) {
            this.accountType = accountType;
            return this;
        }

        public CreateStorageServiceParams build() {
            return CreateStorageServiceParams.create(this.serviceName, this.description, this.label, this.location, this.affinityGroup, this.extendedProperties, this.accountType);
        }

        public Builder fromCreateStorageServiceParams(CreateStorageServiceParams storageServiceParams) {
            return this.serviceName(storageServiceParams.serviceName()).description(storageServiceParams.description()).label(storageServiceParams.label()).location(storageServiceParams.location()).affinityGroup(storageServiceParams.affinityGroup()).extendedProperties(storageServiceParams.extendedProperties()).accountType(storageServiceParams.accountType());
        }
    }
}

