/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.jclouds.azurecompute.domain.AutoValue_CloudService;
import org.jclouds.javax.annotation.Nullable;

public abstract class CloudService {
    CloudService() {
    }

    public abstract String name();

    @Nullable
    public abstract String location();

    @Nullable
    public abstract String affinityGroup();

    public abstract String label();

    @Nullable
    public abstract String description();

    public abstract Status status();

    public abstract Date created();

    public abstract Date lastModified();

    public abstract Map<String, String> extendedProperties();

    public static CloudService create(String name, String location, String affinityGroup, String label, String description, Status status, Date created, Date lastModified, Map<String, String> extendedProperties) {
        return new AutoValue_CloudService(name, location, affinityGroup, label, description, status, created, lastModified, (Map<String, String>)ImmutableMap.copyOf(extendedProperties));
    }

    public static enum Status {
        CREATING,
        CREATED,
        DELETING,
        DELETED,
        CHANGING,
        RESOLVING_DNS,
        UNRECOGNIZED;


        public static Status fromString(String text) {
            if (text != null) {
                for (Status status : Status.values()) {
                    if (!text.equalsIgnoreCase(status.name())) continue;
                    return status;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

