/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import org.jclouds.azurecompute.domain.NetworkConfiguration;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class NetworkConfigurationToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        NetworkConfiguration networkConfiguration = (NetworkConfiguration)NetworkConfiguration.class.cast(input);
        try {
            XMLBuilder builder = XMLBuilder.create((String)"NetworkConfiguration", (String)"http://schemas.microsoft.com/ServiceHosting/2011/07/NetworkConfiguration").e("VirtualNetworkConfiguration");
            if (networkConfiguration.virtualNetworkConfiguration().dns() == null) {
                builder.e("Dns");
            } else {
                builder.e("Dns").t(networkConfiguration.virtualNetworkConfiguration().dns());
            }
            if (!networkConfiguration.virtualNetworkConfiguration().virtualNetworkSites().isEmpty()) {
                XMLBuilder virtualNetworkSitesBuilder = builder.e("VirtualNetworkSites");
                for (NetworkConfiguration.VirtualNetworkSite virtualNetworkSite : networkConfiguration.virtualNetworkConfiguration().virtualNetworkSites()) {
                    XMLBuilder virtualNetworkSiteBuilder = virtualNetworkSitesBuilder.e("VirtualNetworkSite").a("name", virtualNetworkSite.name()).a("Location", virtualNetworkSite.location());
                    virtualNetworkSiteBuilder.e("AddressSpace").e("AddressPrefix").t(virtualNetworkSite.addressSpace().addressPrefix()).up();
                    XMLBuilder subnetBuilder = virtualNetworkSiteBuilder.e("Subnets");
                    for (NetworkConfiguration.Subnet subnet : virtualNetworkSite.subnets()) {
                        subnetBuilder.e("Subnet").a("name", subnet.name()).e("AddressPrefix").t(subnet.addressPrefix());
                    }
                }
            }
            return (R)((HttpRequest.Builder)request.toBuilder().payload(builder.asString())).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

