/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl.parse;

import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.FunctionWithArgs;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.QuotedString;
import org.apache.brooklyn.util.collections.MutableList;

public class DslParser {
    private final String expression;
    int index = -1;

    public DslParser(String expression) {
        this.expression = expression;
    }

    public synchronized Object parse() {
        if (this.index >= 0) {
            throw new IllegalStateException("Parser can only be used once");
        }
        ++this.index;
        Object result = this.next();
        if (this.index < this.expression.length()) {
            throw new IllegalStateException("Unexpected character at position " + this.index + " in " + this.expression);
        }
        return result;
    }

    public Object next() {
        char c;
        int start = this.index;
        this.skipWhitespace();
        if (this.index >= this.expression.length()) {
            throw new IllegalStateException("Unexpected end of expression to parse, looking for content since position " + start);
        }
        if (this.expression.charAt(this.index) == '\"') {
            int stringStart = this.index++;
            while (true) {
                if (this.index >= this.expression.length()) {
                    throw new IllegalStateException("Unexpected end of expression to parse, looking for close quote since position " + stringStart);
                }
                char c2 = this.expression.charAt(this.index);
                if (c2 == '\"') break;
                if (c2 == '\\') {
                    ++this.index;
                }
                ++this.index;
            }
            ++this.index;
            return new QuotedString(this.expression.substring(stringStart, this.index));
        }
        MutableList result = new MutableList();
        int fnStart = this.index;
        while (this.index < this.expression.length() && (Character.isJavaIdentifierPart(c = this.expression.charAt(this.index)) || ".:".indexOf(c) >= 0)) {
            ++this.index;
        }
        String fn = this.expression.substring(fnStart, this.index);
        if (fn.length() == 0) {
            throw new IllegalStateException("Expected a function name at position " + start);
        }
        this.skipWhitespace();
        if (this.index < this.expression.length() && this.expression.charAt(this.index) == '(') {
            char c3;
            int parenStart = this.index++;
            MutableList args = new MutableList();
            while (true) {
                this.skipWhitespace();
                if (this.index >= this.expression.length()) {
                    throw new IllegalStateException("Unexpected end of arguments to function '" + fn + "', no close parenthesis matching character at position " + parenStart);
                }
                c3 = this.expression.charAt(this.index);
                if (c3 == ')') break;
                if (c3 == ',') {
                    if (args.isEmpty()) {
                        throw new IllegalStateException("Invalid character at position" + this.index);
                    }
                    ++this.index;
                } else if (!args.isEmpty()) {
                    throw new IllegalStateException("Expected , before position" + this.index);
                }
                args.add(this.next());
            }
            result.add(new FunctionWithArgs(fn, (List<Object>)args));
            ++this.index;
            this.skipWhitespace();
            if (this.index >= this.expression.length()) {
                return result;
            }
            c3 = this.expression.charAt(this.index);
            if (c3 == '.') {
                int chainStart = this.index++;
                Object next = this.next();
                if (next instanceof List) {
                    result.addAll((Collection)next);
                    return result;
                }
                throw new IllegalStateException("Expected functions following position" + chainStart);
            }
            return result;
        }
        return new FunctionWithArgs(fn, null);
    }

    private void skipWhitespace() {
        while (this.index < this.expression.length() && Character.isWhitespace(this.expression.charAt(this.index))) {
            ++this.index;
        }
    }
}

