/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynEntityDecorationResolver;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlLocationResolver;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlTypeInstantiator;
import org.apache.brooklyn.camp.brooklyn.spi.creation.EntitySpecConfiguration;
import org.apache.brooklyn.camp.brooklyn.spi.creation.service.CampServiceSpecResolver;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigInheritances;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigValueAtContainer;
import org.apache.brooklyn.core.BrooklynFeatureEnablement;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.internal.LazyContainerAndKeyValue;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.mgmt.ManagementContextInjectable;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.core.resolve.entity.EntitySpecResolver;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynComponentTemplateResolver {
    private static final Logger log = LoggerFactory.getLogger(BrooklynComponentTemplateResolver.class);
    private final BrooklynClassLoadingContext loader;
    private final ManagementContext mgmt;
    private final ConfigBag attrs;
    private final Maybe<AbstractResource> template;
    private final BrooklynYamlTypeInstantiator.Factory yamlLoader;
    private final String type;
    private final AtomicBoolean alreadyBuilt = new AtomicBoolean(false);
    private final EntitySpecResolver serviceSpecResolver;

    private BrooklynComponentTemplateResolver(BrooklynClassLoadingContext loader, ConfigBag attrs, AbstractResource optionalTemplate, String type) {
        this.loader = (BrooklynClassLoadingContext)Preconditions.checkNotNull((Object)loader, (Object)"loader");
        this.mgmt = loader.getManagementContext();
        this.attrs = ConfigBag.newInstanceCopying((ConfigBag)attrs);
        this.template = Maybe.fromNullable((Object)optionalTemplate);
        this.yamlLoader = new BrooklynYamlTypeInstantiator.Factory(loader, this);
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.serviceSpecResolver = new CampServiceSpecResolver(this.mgmt, this.getServiceTypeResolverOverrides());
    }

    @Deprecated
    public ManagementContext getManagementContext() {
        return this.mgmt;
    }

    @Deprecated
    public ConfigBag getAttrs() {
        return this.attrs;
    }

    @Deprecated
    public BrooklynYamlTypeInstantiator.Factory getYamlLoader() {
        return this.yamlLoader;
    }

    @Deprecated
    public String getDeclaredType() {
        return this.type;
    }

    public boolean canResolve() {
        return this.serviceSpecResolver.accepts(this.type, this.loader);
    }

    public <T extends Entity> EntitySpec<T> resolveSpec(Set<String> encounteredRegisteredTypeSymbolicNames) {
        if (this.alreadyBuilt.getAndSet(true)) {
            throw new IllegalStateException("Spec resolver can only be used once: " + this);
        }
        EntitySpec spec = this.serviceSpecResolver.resolve(this.type, this.loader, encounteredRegisteredTypeSymbolicNames);
        if (spec == null) {
            RegisteredType item = this.mgmt.getTypeRegistry().get(Strings.removeAllFromStart((String)this.type, (String[])new String[]{"catalog:", "brooklyn:"}));
            String proto = Urls.getProtocol((String)this.type);
            String msgDetails = item != null && encounteredRegisteredTypeSymbolicNames.contains(item.getSymbolicName()) ? "Cycle between catalog items detected, starting from " + this.type + ". Other catalog items being resolved recursively up the stack are " + encounteredRegisteredTypeSymbolicNames + ". Tried loading it as a Java class instead but failed." : (proto != null ? (BrooklynCampConstants.YAML_URL_PROTOCOL_WHITELIST.contains(proto) ? "The reference " + this.type + " looks like a URL (running the CAMP Brooklyn assembly-template instantiator) but couldn't load it (missing or invalid syntax?). It's also neither a catalog item nor a java type." : ("brooklyn".equals(proto) ? "The reference " + this.type + " is not a registered catalog item nor a java type." : "The reference " + this.type + " looks like a URL (running the CAMP Brooklyn assembly-template instantiator) but the protocol " + proto + " isn't white listed (" + BrooklynCampConstants.YAML_URL_PROTOCOL_WHITELIST + "). It's also neither a catalog item nor a java type.")) : "No resolver knew how to handle it. Using resolvers: " + this.serviceSpecResolver);
            throw new IllegalStateException("Unable to create spec for type " + this.type + ". " + msgDetails);
        }
        spec = EntityManagementUtils.unwrapEntity((EntitySpec)spec);
        this.populateSpec(spec, encounteredRegisteredTypeSymbolicNames);
        EntitySpec typedSpec = spec;
        return typedSpec;
    }

    private List<EntitySpecResolver> getServiceTypeResolverOverrides() {
        ArrayList<EntitySpecResolver> overrides = new ArrayList<EntitySpecResolver>();
        return overrides;
    }

    private <T extends Entity> void populateSpec(EntitySpec<T> spec, Set<String> encounteredRegisteredTypeIds) {
        List<LocationSpec<?>> locations;
        Object childrenObj;
        String name;
        String source = null;
        String templateId = null;
        String planId = null;
        if (this.template.isPresent()) {
            name = ((AbstractResource)this.template.get()).getName();
            templateId = ((AbstractResource)this.template.get()).getId();
            source = ((AbstractResource)this.template.get()).getSourceCode();
        } else {
            name = (String)this.attrs.getStringKey("name");
        }
        planId = (String)this.attrs.getStringKey("id");
        if (planId == null) {
            planId = (String)this.attrs.getStringKey("planId");
        }
        if ((childrenObj = this.attrs.getStringKey("brooklyn.children")) != null) {
            Iterable children = (Iterable)childrenObj;
            for (Map childAttrs : children) {
                BrooklynComponentTemplateResolver entityResolver = Factory.newInstance(this.loader, childAttrs);
                EntitySpec<T> childSpec = entityResolver.resolveSpec(encounteredRegisteredTypeIds);
                spec.child(EntityManagementUtils.unwrapEntity(childSpec));
            }
        }
        if (source != null) {
            spec.tag((Object)BrooklynTags.newYamlSpecTag((String)source));
        }
        if (!Strings.isBlank((CharSequence)name)) {
            spec.displayName(name);
        }
        if (templateId != null) {
            spec.configure(BrooklynCampConstants.TEMPLATE_ID, (Object)templateId);
        }
        if (planId != null) {
            spec.configure(BrooklynCampConstants.PLAN_ID, (Object)planId);
        }
        if ((locations = new BrooklynYamlLocationResolver(this.mgmt).resolveLocations(this.attrs.getAllConfig(), true)) != null) {
            spec.clearLocations();
            spec.locationSpecs(locations);
        }
        this.decorateSpec(spec, encounteredRegisteredTypeIds);
    }

    private <T extends Entity> void decorateSpec(EntitySpec<T> spec, Set<String> encounteredRegisteredTypeIds) {
        new BrooklynEntityDecorationResolver.PolicySpecResolver(this.yamlLoader).decorate(spec, this.attrs, encounteredRegisteredTypeIds);
        new BrooklynEntityDecorationResolver.EnricherSpecResolver(this.yamlLoader).decorate(spec, this.attrs, encounteredRegisteredTypeIds);
        new BrooklynEntityDecorationResolver.InitializerResolver(this.yamlLoader).decorate(spec, this.attrs, encounteredRegisteredTypeIds);
        new BrooklynEntityDecorationResolver.SpecParameterResolver(this.yamlLoader).decorate(spec, this.attrs, encounteredRegisteredTypeIds);
        new BrooklynEntityDecorationResolver.TagsResolver(this.yamlLoader).decorate(spec, this.attrs, encounteredRegisteredTypeIds);
        this.configureEntityConfig(spec, encounteredRegisteredTypeIds);
    }

    private void configureEntityConfig(final EntitySpec<?> spec, Set<String> encounteredRegisteredTypeIds) {
        ConfigBag bag = ConfigBag.newInstance((Map)((Map)this.attrs.getStringKey("brooklyn.config")));
        ConfigBag bagFlags = ConfigBag.newInstanceCopying((ConfigBag)this.attrs);
        if (this.attrs.containsKey("brooklyn.flags")) {
            bagFlags.putAll((Map)this.attrs.getStringKey("brooklyn.flags"));
        }
        Collection<FlagUtils.FlagConfigKeyAndValueRecord> topLevelApparentConfig = this.findAllFlagsAndConfigKeyValues(spec, bagFlags);
        for (FlagUtils.FlagConfigKeyAndValueRecord r : topLevelApparentConfig) {
            if (r.getConfigKeyMaybeValue().isPresent()) {
                bag.putIfAbsent(r.getConfigKey(), r.getConfigKeyMaybeValue().get());
            }
            if (!r.getFlagMaybeValue().isPresent()) continue;
            bag.putAsStringKeyIfAbsent((Object)r.getFlagName(), r.getFlagMaybeValue().get());
        }
        Map<String, ConfigKey<?>> entityConfigKeys = this.findAllConfigKeys(spec);
        Collection<FlagUtils.FlagConfigKeyAndValueRecord> records = this.findAllFlagsAndConfigKeyValues(spec, bag);
        LinkedHashSet<String> keyNamesUsed = new LinkedHashSet<String>();
        for (FlagUtils.FlagConfigKeyAndValueRecord flagConfigKeyAndValueRecord : records) {
            Function rawConvFn = Functions.identity();
            if (flagConfigKeyAndValueRecord.getFlagMaybeValue().isPresent()) {
                final String flag = flagConfigKeyAndValueRecord.getFlagName();
                ConfigKey key = flagConfigKeyAndValueRecord.getConfigKey();
                if (key == null) {
                    ConfigKeys.newConfigKey(Object.class, (String)flag);
                }
                Object ownValueF = new SpecialFlagsTransformer(this.loader, encounteredRegisteredTypeIds).apply(flagConfigKeyAndValueRecord.getFlagMaybeValue().get());
                Function rawEvalFn = new Function<EntitySpec<?>, Maybe<Object>>(){

                    public Maybe<Object> apply(EntitySpec<?> input) {
                        return spec.getFlags().containsKey(flag) ? Maybe.of(spec.getFlags().get(flag)) : Maybe.absent();
                    }
                };
                MutableList ckvi = MutableList.of((Object)new LazyContainerAndKeyValue(key, null, rawEvalFn, rawConvFn));
                ConfigValueAtContainer combinedVal = (ConfigValueAtContainer)ConfigInheritances.resolveInheriting(null, (ConfigKey)key, (Maybe)Maybe.ofAllowingNull((Object)ownValueF), (Maybe)Maybe.absent(), ckvi.iterator(), (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.TYPE_DEFINITION, (ConfigInheritance)this.getDefaultConfigInheritance()).getWithoutError();
                spec.configure((CharSequence)flag, combinedVal.get());
                keyNamesUsed.add(flag);
            }
            if (!flagConfigKeyAndValueRecord.getConfigKeyMaybeValue().isPresent()) continue;
            final ConfigKey key = flagConfigKeyAndValueRecord.getConfigKey();
            Object ownValueF = new SpecialFlagsTransformer(this.loader, encounteredRegisteredTypeIds).apply(flagConfigKeyAndValueRecord.getConfigKeyMaybeValue().get());
            Function rawEvalFn = new Function<EntitySpec<?>, Maybe<Object>>(){

                public Maybe<Object> apply(EntitySpec<?> input) {
                    return spec.getConfig().containsKey(key) ? Maybe.of(spec.getConfig().get(key)) : Maybe.absent();
                }
            };
            MutableList ckvi = MutableList.of((Object)new LazyContainerAndKeyValue(key, null, rawEvalFn, rawConvFn));
            ConfigValueAtContainer combinedVal = (ConfigValueAtContainer)ConfigInheritances.resolveInheriting(null, (ConfigKey)key, (Maybe)Maybe.ofAllowingNull((Object)ownValueF), (Maybe)Maybe.absent(), ckvi.iterator(), (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.TYPE_DEFINITION, (ConfigInheritance)this.getDefaultConfigInheritance()).getWithoutError();
            spec.configure(key, combinedVal.get());
            keyNamesUsed.add(key.getName());
        }
        for (Map.Entry entry : entityConfigKeys.entrySet()) {
            ConfigKey key;
            if (keyNamesUsed.contains(entry.getKey()) || ConfigInheritances.isKeyReinheritable((ConfigKey)(key = (ConfigKey)entry.getValue()), (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.TYPE_DEFINITION)) continue;
            spec.removeConfig(key);
            spec.removeFlag(key.getName());
        }
        for (String string : MutableSet.copyOf(bag.getUnusedConfig().keySet())) {
            if (keyNamesUsed.contains(string)) continue;
            Object transformed = new SpecialFlagsTransformer(this.loader, encounteredRegisteredTypeIds).apply(bag.getStringKey(string));
            spec.configure(ConfigKeys.newConfigKey(Object.class, (String)string.toString()), transformed);
        }
    }

    protected ConfigInheritance getDefaultConfigInheritance() {
        return BasicConfigInheritance.OVERWRITE;
    }

    private Collection<FlagUtils.FlagConfigKeyAndValueRecord> findAllFlagsAndConfigKeyValues(EntitySpec<?> spec, ConfigBag bagFlags) {
        MutableList allKeys = MutableList.of();
        allKeys.addAll(FlagUtils.findAllParameterConfigKeys((List)spec.getParameters(), (ConfigBag)bagFlags));
        if (spec.getImplementation() != null) {
            allKeys.addAll(FlagUtils.findAllFlagsAndConfigKeys(null, (Class)spec.getImplementation(), (ConfigBag)bagFlags));
        }
        allKeys.addAll(FlagUtils.findAllFlagsAndConfigKeys(null, (Class)spec.getType(), (ConfigBag)bagFlags));
        for (Class iface : spec.getAdditionalInterfaces()) {
            allKeys.addAll(FlagUtils.findAllFlagsAndConfigKeys(null, (Class)iface, (ConfigBag)bagFlags));
        }
        return allKeys;
    }

    private Map<String, ConfigKey<?>> findAllConfigKeys(EntitySpec<?> spec) {
        MutableSet types = MutableSet.builder().add((Object)spec.getImplementation()).add((Object)spec.getType()).addAll((Iterable)spec.getAdditionalInterfaces()).remove(null).build();
        MutableMap result = MutableMap.copyOf((Map)FlagUtils.findAllConfigKeys(null, (Iterable)types));
        for (SpecParameter param : spec.getParameters()) {
            result.put((Object)param.getConfigKey().getName(), (Object)param.getConfigKey());
        }
        return result;
    }

    public static class SpecialFlagsTransformer
    implements Function<Object, Object> {
        protected final ManagementContext mgmt;
        private BrooklynClassLoadingContext loader = null;
        private Set<String> encounteredRegisteredTypeIds;

        public SpecialFlagsTransformer(BrooklynClassLoadingContext loader, Set<String> encounteredRegisteredTypeIds) {
            this.loader = loader;
            this.mgmt = loader.getManagementContext();
            this.encounteredRegisteredTypeIds = encounteredRegisteredTypeIds;
        }

        public Object apply(Object input) {
            if (input instanceof Map) {
                return this.transformSpecialFlags((Map)input);
            }
            if (input instanceof Set) {
                return MutableSet.copyOf(this.transformSpecialFlags((Iterable)input));
            }
            if (input instanceof List) {
                return MutableList.copyOf(this.transformSpecialFlags((Iterable)input));
            }
            if (input instanceof Iterable) {
                return this.transformSpecialFlags((Iterable)input);
            }
            return this.transformSpecialFlags(input);
        }

        protected Map<?, ?> transformSpecialFlags(Map<?, ?> flag) {
            return Maps.transformValues(flag, (Function)this);
        }

        protected Iterable<?> transformSpecialFlags(Iterable<?> flag) {
            return Iterables.transform(flag, (Function)this);
        }

        protected BrooklynClassLoadingContext getLoader() {
            if (this.loader != null) {
                return this.loader;
            }
            Entity entity = BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
            if (entity != null) {
                return CatalogUtils.getClassLoadingContext((Entity)entity);
            }
            return JavaBrooklynClassLoadingContext.create((ManagementContext)this.mgmt);
        }

        protected Object transformSpecialFlags(Object flag) {
            if (flag instanceof EntitySpecConfiguration) {
                EntitySpecSupplier supplier = new EntitySpecSupplier((EntitySpecConfiguration)flag);
                EntitySpec<?> resolved = supplier.get();
                if (BrooklynFeatureEnablement.isEnabled((String)"brooklyn.experimental.feature.persist.entitySpecAsSupplier")) {
                    return supplier;
                }
                return resolved;
            }
            if (flag instanceof ManagementContextInjectable) {
                log.debug("Injecting Brooklyn management context info object: {}", flag);
                ((ManagementContextInjectable)flag).setManagementContext(this.loader.getManagementContext());
            }
            return flag;
        }

        private class EntitySpecSupplier
        implements DeferredSupplier<EntitySpec<?>> {
            EntitySpecConfiguration flag;

            public EntitySpecSupplier(EntitySpecConfiguration flag) {
                this.flag = flag;
            }

            public EntitySpec<?> get() {
                Map<?, ?> resolvedConfig = SpecialFlagsTransformer.this.transformSpecialFlags(this.flag.getSpecConfiguration());
                EntitySpec entitySpec = Factory.newInstance(SpecialFlagsTransformer.this.getLoader(), resolvedConfig).resolveSpec(SpecialFlagsTransformer.this.encounteredRegisteredTypeIds);
                return EntityManagementUtils.unwrapEntity(entitySpec);
            }
        }
    }

    public static class Factory {
        public static BrooklynComponentTemplateResolver newInstance(BrooklynClassLoadingContext context, Map<String, ?> childAttrs) {
            return Factory.newInstance(context, ConfigBag.newInstance(childAttrs), null);
        }

        public static BrooklynComponentTemplateResolver newInstance(BrooklynClassLoadingContext context, AbstractResource template) {
            return Factory.newInstance(context, ConfigBag.newInstance((Map)template.getCustomAttributes()), template);
        }

        public static BrooklynComponentTemplateResolver newInstance(BrooklynClassLoadingContext context, String serviceType) {
            return Factory.newInstance(context, ConfigBag.newInstance().configureStringKey("serviceType", (Object)serviceType), null);
        }

        private static BrooklynComponentTemplateResolver newInstance(BrooklynClassLoadingContext context, ConfigBag attrs, AbstractResource optionalTemplate) {
            String type = Factory.getDeclaredType(null, optionalTemplate, attrs);
            if (Strings.isBlank((CharSequence)type)) {
                String msg = "No type defined " + (attrs == null ? ", no attributes supplied" : "in [" + attrs.getAllConfigRaw() + "]") + (optionalTemplate == null ? "" : ", template " + optionalTemplate);
                throw new IllegalArgumentException(msg);
            }
            return new BrooklynComponentTemplateResolver(context, attrs, optionalTemplate, type);
        }

        private static String getDeclaredType(String knownServiceType, AbstractResource optionalTemplate, @Nullable ConfigBag attrs) {
            String type = knownServiceType;
            if (type == null && optionalTemplate != null && ((type = optionalTemplate.getType()).equals("AssemblyTemplate") || type.equals("PlatformComponentTemplate") || type.equals("ApplicationComponentTemplate"))) {
                type = null;
            }
            if (type == null) {
                type = Factory.extractServiceTypeAttribute(attrs);
            }
            return type;
        }

        private static String extractServiceTypeAttribute(@Nullable ConfigBag attrs) {
            return (String)BrooklynYamlTypeInstantiator.InstantiatorFromKey.extractTypeName("service", attrs).orNull();
        }
    }
}

