/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_NetworkInterfaceCardProperties;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.IpConfiguration;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class NetworkInterfaceCardProperties
implements Provisionable {
    @Override
    @Nullable
    public abstract String provisioningState();

    @Nullable
    public abstract String resourceGuid();

    @Nullable
    public abstract Boolean enableIPForwarding();

    @Nullable
    public abstract List<IpConfiguration> ipConfigurations();

    @Nullable
    public abstract IdReference networkSecurityGroup();

    @SerializedNames(value={"provisioningState", "resourceGuid", "enableIPForwarding", "ipConfigurations", "networkSecurityGroup"})
    public static NetworkInterfaceCardProperties create(String provisioningState, String resourceGuid, Boolean enableIPForwarding, List<IpConfiguration> ipConfigurations, IdReference networkSecurityGroup) {
        Builder builder = NetworkInterfaceCardProperties.builder().provisioningState(provisioningState).resourceGuid(resourceGuid).enableIPForwarding(enableIPForwarding).ipConfigurations((List<IpConfiguration>)(ipConfigurations == null ? null : ImmutableList.copyOf(ipConfigurations))).networkSecurityGroup(networkSecurityGroup);
        return builder.build();
    }

    NetworkInterfaceCardProperties() {
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_NetworkInterfaceCardProperties.Builder();
    }

    public static abstract class Builder {
        public abstract Builder provisioningState(String var1);

        public abstract Builder resourceGuid(String var1);

        public abstract Builder enableIPForwarding(Boolean var1);

        public abstract Builder ipConfigurations(List<IpConfiguration> var1);

        public abstract Builder networkSecurityGroup(IdReference var1);

        abstract List<IpConfiguration> ipConfigurations();

        abstract NetworkInterfaceCardProperties autoBuild();

        public NetworkInterfaceCardProperties build() {
            this.ipConfigurations((List<IpConfiguration>)(this.ipConfigurations() != null ? ImmutableList.copyOf(this.ipConfigurations()) : null));
            return this.autoBuild();
        }
    }
}

