/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.rest.api.PolicyConfigApi;
import org.apache.brooklyn.rest.domain.PolicyConfigSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.transform.PolicyTransformer;
import org.apache.brooklyn.rest.util.BrooklynRestResourceUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;

@HaHotStateRequired
@Deprecated
public class PolicyConfigResource
extends AbstractBrooklynRestResource
implements PolicyConfigApi {
    public List<PolicyConfigSummary> list(String application, String entityToken, String policyToken) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        Policy policy = this.brooklyn().getPolicy(entity, policyToken);
        ArrayList result = Lists.newArrayList();
        for (ConfigKey key : policy.getPolicyType().getConfigKeys()) {
            result.add(PolicyTransformer.policyConfigSummary(this.brooklyn(), entity, policy, key, this.ui.getBaseUriBuilder()));
        }
        return result;
    }

    public Map<String, Object> batchConfigRead(String application, String entityToken, String policyToken) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        Map source = ConfigBag.newInstance((Map)((BrooklynObjectInternal)policy).config().getInternalConfigMap().getAllConfigInheritedRawValuesIgnoringErrors()).getAllConfig();
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry ek : source.entrySet()) {
            result.put(ek.getKey(), PolicyConfigResource.getStringValueForDisplay(this.brooklyn(), policy, ek.getValue()));
        }
        return result;
    }

    public String get(String application, String entityToken, String policyToken, String configKeyName) {
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        ConfigKey ck = policy.getPolicyType().getConfigKey(configKeyName);
        if (ck == null) {
            throw WebResourceUtils.notFound("Cannot find config key '%s' in policy '%s' of entity '%s'", configKeyName, policy, entityToken);
        }
        return PolicyConfigResource.getStringValueForDisplay(this.brooklyn(), policy, policy.getConfig(ck));
    }

    public Response set(String application, String entityToken, String policyToken, String configKeyName, Object value) {
        Entity entity = this.brooklyn().getEntity(application, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        Policy policy = this.brooklyn().getPolicy(application, entityToken, policyToken);
        ConfigKey ck = policy.getPolicyType().getConfigKey(configKeyName);
        if (ck == null) {
            throw WebResourceUtils.notFound("Cannot find config key '%s' in policy '%s' of entity '%s'", configKeyName, policy, entityToken);
        }
        policy.config().set(ck, TypeCoercions.coerce((Object)value, (TypeToken)ck.getTypeToken()));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public static String getStringValueForDisplay(BrooklynRestResourceUtils utils, Policy policy, Object value) {
        return utils.getStringValueForDisplay(value);
    }
}

