/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.java;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.brooklyn.entity.java.JmxSupport;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.crypto.FluentKeySigner;
import org.apache.brooklyn.util.core.crypto.SecureKeys;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Urls;

public class JmxmpSslSupport {
    static final String BROOKLYN_VERSION = "1.0.0-M1";
    private final JmxSupport jmxSupport;
    private KeyStore agentTrustStore;
    private KeyStore agentKeyStore;

    public JmxmpSslSupport(JmxSupport jmxSupport) {
        this.jmxSupport = (JmxSupport)Preconditions.checkNotNull((Object)jmxSupport);
    }

    public String getJmxSslKeyStoreFilePath() {
        return Urls.mergePaths((String[])new String[]{this.jmxSupport.getRunDir(), "jmx-keystore"});
    }

    public String getJmxSslTrustStoreFilePath() {
        return Urls.mergePaths((String[])new String[]{this.jmxSupport.getRunDir(), "jmx-truststore"});
    }

    public void applyAgentJmxJavaSystemProperties(MutableMap.Builder<String, Object> result) {
        result.put((Object)"com.sun.management.jmxremote.ssl", (Object)true).put((Object)"brooklyn.jmxmp.ssl.authenticate", (Object)true).put((Object)"com.sun.management.jmxremote.authenticate", (Object)false);
        result.put((Object)"brooklyn.jmxmp.ssl.keyStore", (Object)this.getJmxSslKeyStoreFilePath()).put((Object)"brooklyn.jmxmp.ssl.trustStore", (Object)this.getJmxSslTrustStoreFilePath());
    }

    public FluentKeySigner getBrooklynRootSigner() {
        return new FluentKeySigner("brooklyn-root");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() {
        try {
            FluentKeySigner signer = this.getBrooklynRootSigner();
            KeyPair jmxAgentKey = SecureKeys.newKeyPair();
            X509Certificate jmxAgentCert = signer.newCertificateFor("jmxmp-agent", jmxAgentKey);
            this.agentKeyStore = SecureKeys.newKeyStore();
            this.agentKeyStore.setKeyEntry("jmxmp-agent", jmxAgentKey.getPrivate(), "".toCharArray(), new Certificate[]{jmxAgentCert});
            ByteArrayOutputStream agentKeyStoreBytes = new ByteArrayOutputStream();
            this.agentKeyStore.store(agentKeyStoreBytes, "".toCharArray());
            this.agentTrustStore = SecureKeys.newKeyStore();
            this.agentTrustStore.setCertificateEntry("brooklyn", this.getJmxAccessCert());
            ByteArrayOutputStream agentTrustStoreBytes = new ByteArrayOutputStream();
            this.agentTrustStore.store(agentTrustStoreBytes, "".toCharArray());
            Tasks.setBlockingDetails((String)"Copying keystore and truststore to the server.");
            try {
                ((SshMachineLocation)this.jmxSupport.getMachine().get()).copyTo((InputStream)new ByteArrayInputStream(agentKeyStoreBytes.toByteArray()), this.getJmxSslKeyStoreFilePath());
                ((SshMachineLocation)this.jmxSupport.getMachine().get()).copyTo((InputStream)new ByteArrayInputStream(agentTrustStoreBytes.toByteArray()), this.getJmxSslTrustStoreFilePath());
            }
            finally {
                Tasks.resetBlockingDetails();
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public synchronized Certificate getJmxAccessCert() {
        Certificate cert = this.jmxSupport.getConfig(UsesJmx.JMX_SSL_ACCESS_CERT);
        if (cert != null) {
            return cert;
        }
        KeyPair jmxAccessKey = SecureKeys.newKeyPair();
        X509Certificate jmxAccessCert = this.getBrooklynRootSigner().newCertificateFor("brooklyn-jmx-access", jmxAccessKey);
        this.jmxSupport.setConfig(UsesJmx.JMX_SSL_ACCESS_CERT, jmxAccessCert);
        this.jmxSupport.setConfig(UsesJmx.JMX_SSL_ACCESS_KEY, jmxAccessKey.getPrivate());
        return jmxAccessCert;
    }

    public synchronized PrivateKey getJmxAccessKey() {
        PrivateKey key = this.jmxSupport.getConfig(UsesJmx.JMX_SSL_ACCESS_KEY);
        if (key != null) {
            return key;
        }
        this.getJmxAccessCert();
        return this.jmxSupport.getConfig(UsesJmx.JMX_SSL_ACCESS_KEY);
    }
}

