/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.PublicIPAddressProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class PublicIPAddress {
    public abstract String name();

    public abstract String id();

    public abstract String etag();

    public abstract String location();

    @Nullable
    public abstract Map<String, String> tags();

    public abstract PublicIPAddressProperties properties();

    @SerializedNames(value={"name", "id", "etag", "location", "tags", "properties"})
    public static PublicIPAddress create(String name, String id, String etag, String location, Map<String, String> tags, PublicIPAddressProperties properties) {
        return PublicIPAddress.builder().name(name).id(id).etag(etag).location(location).tags(tags).properties(properties).build();
    }

    PublicIPAddress() {
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_PublicIPAddress.Builder();
    }

    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder id(String var1);

        public abstract Builder etag(String var1);

        public abstract Builder location(String var1);

        public abstract Builder tags(Map<String, String> var1);

        public abstract Builder properties(PublicIPAddressProperties var1);

        abstract Map<String, String> tags();

        abstract PublicIPAddress autoBuild();

        public PublicIPAddress build() {
            this.tags((Map<String, String>)(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null));
            return this.autoBuild();
        }
    }
}

