/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.winrm;

import io.cloudsoft.winrm4j.client.WinRmClient;
import io.cloudsoft.winrm4j.client.WinRmClientContext;
import io.cloudsoft.winrm4j.winrm.WinRmToolResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRmTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)WinRmTool.class.getName());
    public static final int DEFAULT_WINRM_PORT = 5985;
    public static final int DEFAULT_WINRM_HTTPS_PORT = 5986;
    private final String address;
    private final String domain;
    private final String username;
    private final String password;
    private final String authenticationScheme;
    private Long operationTimeout;
    private Integer retriesForConnectionFailures;
    private final boolean disableCertificateChecks;
    private final String workingDirectory;
    private final Map<String, String> environment;
    private final HostnameVerifier hostnameVerifier;
    private final WinRmClientContext context;

    private WinRmTool(String address, String domain, String username, String password, String authenticationScheme, boolean disableCertificateChecks, String workingDirectory, Map<String, String> environment, HostnameVerifier hostnameVerifier, WinRmClientContext context) {
        this.disableCertificateChecks = disableCertificateChecks;
        this.address = address;
        this.domain = domain;
        this.username = username;
        this.password = password;
        this.authenticationScheme = authenticationScheme;
        this.workingDirectory = workingDirectory;
        this.environment = environment;
        this.hostnameVerifier = hostnameVerifier;
        this.context = context;
    }

    public WinRmToolResponse executeCommand(List<String> commands) {
        return this.executeCommand(this.joinCommands(commands));
    }

    public void setOperationTimeout(Long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public void setRetriesForConnectionFailures(Integer retriesForConnectionFailures) {
        this.retriesForConnectionFailures = retriesForConnectionFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WinRmToolResponse executeCommand(String command) {
        WinRmClient.Builder builder = WinRmClient.builder((String)this.address, (String)this.authenticationScheme);
        if (this.operationTimeout != null) {
            builder.operationTimeout(this.operationTimeout.longValue());
        }
        if (this.username != null && this.password != null) {
            builder.credentials(this.domain, this.username, this.password);
        }
        if (this.disableCertificateChecks) {
            LOG.trace("Disabled check for https connections " + this);
            builder.disableCertificateChecks(this.disableCertificateChecks);
        }
        if (this.hostnameVerifier != null) {
            builder.hostnameVerifier(this.hostnameVerifier);
        }
        if (this.workingDirectory != null) {
            builder.workingDirectory(this.workingDirectory);
        }
        if (this.environment != null) {
            builder.environment(this.environment);
        }
        if (this.retriesForConnectionFailures != null) {
            builder.retriesForConnectionFailures(this.retriesForConnectionFailures);
        }
        if (this.context != null) {
            builder.context(this.context);
        }
        WinRmClient client = builder.build();
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        try {
            int code = client.command(command, (Writer)out, (Writer)err);
            WinRmToolResponse winRmToolResponse = new WinRmToolResponse(out.toString(), err.toString(), code);
            winRmToolResponse.setNumberOfReceiveCalls(client.getNumberOfReceiveCalls());
            WinRmToolResponse winRmToolResponse2 = winRmToolResponse;
            return winRmToolResponse2;
        }
        finally {
            client.disconnect();
        }
    }

    public WinRmToolResponse executePs(String psCommand) {
        return this.executeCommand(this.compilePs(psCommand));
    }

    public WinRmToolResponse executePs(List<String> commands) {
        return this.executeCommand(this.compilePs(this.joinPs(commands)));
    }

    private String compilePs(String psScript) {
        byte[] cmd = psScript.getBytes(Charset.forName("UTF-16LE"));
        String arg = DatatypeConverter.printBase64Binary((byte[])cmd);
        return "powershell -encodedcommand " + arg;
    }

    @Deprecated
    public WinRmToolResponse executeScript(List<String> commands) {
        return this.executeCommand(commands);
    }

    @Deprecated
    public WinRmToolResponse executeScript(String commands) {
        return this.executeCommand(commands);
    }

    private String joinCommands(List<String> commands) {
        return this.join(commands, " & ", false);
    }

    private String joinPs(List<String> commands) {
        return this.join(commands, "\r\n", true);
    }

    private String join(List<String> commands, String delim, boolean endWithDelim) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String command : commands) {
            if (first) {
                first = false;
            } else {
                builder.append(delim);
            }
            builder.append(command);
        }
        if (endWithDelim) {
            builder.append(delim);
        }
        return builder.toString();
    }

    public static class Builder {
        private String authenticationScheme = "NTLM";
        private Boolean useHttps;
        private Integer port = null;
        private boolean disableCertificateChecks = false;
        private String address;
        private String domain;
        private String username;
        private String password;
        private String workingDirectory;
        private Map<String, String> environment;
        private HostnameVerifier hostnameVerifier;
        private WinRmClientContext context;
        private static final Pattern matchPort = Pattern.compile(".*:(\\d+)$");

        public static Builder builder(String address, String username, String password) {
            return Builder.builder(address, null, username, password);
        }

        public static Builder builder(String address, String domain, String username, String password) {
            return new Builder(address, domain, username, password);
        }

        private Builder(String address, String domain, String username, String password) {
            this.address = address;
            this.domain = domain;
            this.username = username;
            this.password = password;
        }

        public Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = (String)WinRmClient.checkNotNull((Object)workingDirectory, (String)"workingDirectory");
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = (Map)WinRmClient.checkNotNull(environment, (String)"environment");
            return this;
        }

        public Builder setAuthenticationScheme(String authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        public Builder disableCertificateChecks(boolean disableCertificateChecks) {
            this.disableCertificateChecks = disableCertificateChecks;
            return this;
        }

        public Builder useHttps(boolean useHttps) {
            this.useHttps = useHttps;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder context(WinRmClientContext context) {
            this.context = context;
            return this;
        }

        public WinRmTool build() {
            return new WinRmTool(Builder.getEndpointUrl(this.address, this.useHttps, this.port), this.domain, this.username, this.password, this.authenticationScheme, this.disableCertificateChecks, this.workingDirectory, this.environment, this.hostnameVerifier, this.context);
        }

        private static String getEndpointUrl(String address, Boolean useHttps, Integer port) {
            if (address.startsWith("http:") || address.startsWith("https:")) {
                if (useHttps != null) {
                    if (useHttps.booleanValue() && address.startsWith("http:")) {
                        throw new IllegalArgumentException("Invalid setting useHttps and address starting http://");
                    }
                    if (!useHttps.booleanValue() && address.startsWith("https:")) {
                        throw new IllegalArgumentException("Invalid setting useHttp and address starting https://");
                    }
                }
                return address;
            }
            Matcher matcher = matchPort.matcher(address);
            if (matcher.matches()) {
                if (useHttps == null) {
                    useHttps = matcher.group(1).equals("5986");
                }
                return (useHttps != false ? "https" : "http") + "://" + address + "/wsman";
            }
            if (useHttps != null) {
                port = port != null ? port : (useHttps != false ? 5986 : 5985);
            }
            if (useHttps != null && useHttps.booleanValue()) {
                return "https://" + address + ":" + port + "/wsman";
            }
            return "http://" + address + ":" + port + "/wsman";
        }
    }
}

