/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock.aggregator;

import com.google.common.annotations.Beta;
import java.util.concurrent.Callable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.enricher.stock.aggregator.AggregationJob;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.time.Duration;

@Beta
public class DashboardAggregator
extends AbstractEnricher {
    private ScheduledTask task;
    public static BasicAttributeSensorAndConfigKey<Duration> DASHBOARD_COST_PER_MONTH = new BasicAttributeSensorAndConfigKey<Duration>(Duration.class, "dashboard.period", "The amount of time to wait between aggregation jobs", Duration.seconds((Number)1));

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        Duration duration = (Duration)this.config().get(DASHBOARD_COST_PER_MONTH);
        Callable<Task<?>> taskFactory = () -> Tasks.builder().dynamic(false).body(new AggregationJob((Entity)entity)).displayName("DashboardAggregator task").tag("TRANSIENT").description("Retrieves and aggregates sensor values").build();
        this.task = ScheduledTask.builder(taskFactory).period(duration).displayName("scheduled:[DashboardAggregator task]").tagTransient().build();
        this.getManagementContext().getExecutionManager().submit((TaskAdaptable)this.task);
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

