/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.SubscriptionContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.AbstractSubscriptionManager;
import org.apache.brooklyn.core.mgmt.internal.EntityChangeListener;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementTransitionInfo;
import org.apache.brooklyn.core.mgmt.internal.NonDeploymentManagementContext;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagementSupport {
    private static final Logger log = LoggerFactory.getLogger(EntityManagementSupport.class);
    protected transient AbstractEntity entity;
    NonDeploymentManagementContext nonDeploymentManagementContext;
    protected transient ManagementContext initialManagementContext;
    protected transient ManagementContext managementContext;
    protected volatile transient SubscriptionContext subscriptionContext;
    protected volatile transient ExecutionContext executionContext;
    protected final AtomicBoolean managementContextUsable = new AtomicBoolean(false);
    protected final AtomicBoolean currentlyDeployed = new AtomicBoolean(false);
    protected final AtomicBoolean everDeployed = new AtomicBoolean(false);
    protected Boolean readOnly = null;
    protected final AtomicBoolean managementFailed = new AtomicBoolean(false);
    private volatile EntityChangeListener entityChangeListener = EntityChangeListener.NOOP;

    public EntityManagementSupport(AbstractEntity entity) {
        this.entity = entity;
        this.nonDeploymentManagementContext = new NonDeploymentManagementContext(entity, NonDeploymentManagementContext.NonDeploymentManagementContextMode.PRE_MANAGEMENT);
    }

    public boolean isDeployed() {
        return this.currentlyDeployed.get();
    }

    public boolean isNoLongerManaged() {
        return this.wasDeployed() && !this.isDeployed();
    }

    public boolean wasDeployed() {
        return this.everDeployed.get();
    }

    @Beta
    public void setReadOnly(boolean isReadOnly) {
        if (this.isDeployed()) {
            throw new IllegalStateException("Cannot set read only after deployment");
        }
        this.readOnly = isReadOnly;
    }

    @Beta
    public Boolean isReadOnlyRaw() {
        return this.readOnly;
    }

    @Beta
    public boolean isReadOnly() {
        Preconditions.checkNotNull((Object)this.readOnly, (String)"Read-only status of %s not yet known", (Object[])new Object[]{this.entity});
        return this.readOnly;
    }

    public boolean isFullyManaged() {
        return this.nonDeploymentManagementContext == null && this.currentlyDeployed.get();
    }

    public synchronized void setManagementContext(ManagementContextInternal val) {
        if (this.initialManagementContext != null) {
            throw new IllegalStateException("Initial management context is already set for " + this.entity + "; cannot change");
        }
        if (this.managementContext != null && !this.managementContext.equals(val)) {
            throw new IllegalStateException("Management context is already set for " + this.entity + "; cannot change");
        }
        this.initialManagementContext = (ManagementContext)Preconditions.checkNotNull((Object)val, (Object)"managementContext");
        if (this.nonDeploymentManagementContext != null) {
            this.nonDeploymentManagementContext.setManagementContext(val);
        }
    }

    public void onRebind(ManagementTransitionInfo info) {
        this.nonDeploymentManagementContext.setMode(NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_REBINDING);
    }

    public void onManagementStarting(ManagementTransitionInfo info) {
        info.getManagementContext().getExecutionContext((Entity)this.entity).get(Tasks.builder().displayName("Management starting").dynamic(false).tag("TRANSIENT").body(() -> {
            try {
                EntityManagementSupport entityManagementSupport = this;
                synchronized (entityManagementSupport) {
                    boolean alreadyManaging = this.isDeployed();
                    if (alreadyManaging) {
                        log.warn("Already managed: " + this.entity + " (" + this.nonDeploymentManagementContext + "); onManagementStarting is no-op");
                    } else if (this.nonDeploymentManagementContext == null || !this.nonDeploymentManagementContext.getMode().isPreManaged()) {
                        throw new IllegalStateException("Not in expected pre-managed state: " + this.entity + " (" + this.nonDeploymentManagementContext + ")");
                    }
                    if (this.managementContext != null && !this.managementContext.equals(info.getManagementContext())) {
                        throw new IllegalStateException("Already has management context: " + this.managementContext + "; can't set " + info.getManagementContext());
                    }
                    if (this.initialManagementContext != null && !this.initialManagementContext.equals(info.getManagementContext())) {
                        throw new IllegalStateException("Already has different initial management context: " + this.initialManagementContext + "; can't set " + info.getManagementContext());
                    }
                    if (alreadyManaging) {
                        return;
                    }
                    this.managementContext = info.getManagementContext();
                    this.nonDeploymentManagementContext.setMode(NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_STARTING);
                    if (!this.isReadOnly()) {
                        this.nonDeploymentManagementContext.getSubscriptionManager().setDelegate((AbstractSubscriptionManager)this.managementContext.getSubscriptionManager());
                        this.nonDeploymentManagementContext.getSubscriptionManager().startDelegatingForSubscribing();
                    }
                    this.managementContextUsable.set(true);
                    this.currentlyDeployed.set(true);
                    this.everDeployed.set(true);
                    this.entityChangeListener = new EntityChangeListenerImpl();
                }
                if (!this.isReadOnly()) {
                    this.entity.onManagementStarting();
                }
            }
            catch (Throwable t) {
                this.managementFailed.set(true);
                throw Exceptions.propagate((Throwable)t);
            }
        }).build());
    }

    public void onManagementStarted(ManagementTransitionInfo info) {
        info.getManagementContext().getExecutionContext((Entity)this.entity).get(Tasks.builder().displayName("Management started").dynamic(false).tag("TRANSIENT").body(() -> {
            try {
                EntityManagementSupport entityManagementSupport = this;
                synchronized (entityManagementSupport) {
                    boolean alreadyManaged = this.isFullyManaged();
                    if (alreadyManaged) {
                        log.warn("Already managed: " + this.entity + " (" + this.nonDeploymentManagementContext + "); onManagementStarted is no-op");
                    } else if (this.nonDeploymentManagementContext == null || this.nonDeploymentManagementContext.getMode() != NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_STARTING) {
                        throw new IllegalStateException("Not in expected \"management starting\" state: " + this.entity + " (" + this.nonDeploymentManagementContext + ")");
                    }
                    if (this.managementContext != info.getManagementContext()) {
                        throw new IllegalStateException("Already has management context: " + this.managementContext + "; can't set " + info.getManagementContext());
                    }
                    if (alreadyManaged) {
                        return;
                    }
                    this.nonDeploymentManagementContext.setMode(NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_STARTED);
                }
                if (!this.isReadOnly()) {
                    this.nonDeploymentManagementContext.getSubscriptionManager().startDelegatingForPublishing();
                }
                if (!this.isReadOnly()) {
                    this.entity.onManagementBecomingMaster();
                    this.entity.onManagementStarted();
                }
                entityManagementSupport = this;
                synchronized (entityManagementSupport) {
                    this.nonDeploymentManagementContext = null;
                }
            }
            catch (Throwable t) {
                this.managementFailed.set(true);
                throw Exceptions.propagate((Throwable)t);
            }
        }).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onManagementStopping(ManagementTransitionInfo info) {
        EntityManagementSupport entityManagementSupport = this;
        synchronized (entityManagementSupport) {
            if (this.managementContext != info.getManagementContext()) {
                throw new IllegalStateException("onManagementStopping encountered different management context for " + this.entity + (!this.wasDeployed() ? " (wasn't deployed)" : (!this.isDeployed() ? " (no longer deployed)" : "")) + ": " + this.managementContext + "; expected " + info.getManagementContext() + " (may be a pre-registered entity which was never properly managed)");
            }
            Stopwatch startTime = Stopwatch.createStarted();
            while (!this.managementFailed.get() && this.nonDeploymentManagementContext != null && this.nonDeploymentManagementContext.getMode() == NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_STARTING) {
                try {
                    if (startTime.elapsed(TimeUnit.SECONDS) > 30L) {
                        log.error("Management stopping event " + info + " in " + this + " timed out waiting for start; proceeding to stopping");
                        break;
                    }
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    Exceptions.propagate((Throwable)e);
                }
            }
            if (this.nonDeploymentManagementContext == null) {
                this.nonDeploymentManagementContext = new NonDeploymentManagementContext(this.entity, NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_STOPPING);
            } else {
                this.nonDeploymentManagementContext.setMode(NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_STOPPING);
            }
        }
        if (!this.isReadOnly() && info.getMode().isDestroying() && this.entity.getParent() != null) {
            this.entity.getParent().removeChild(this.entity.getProxyIfAvailable());
        }
        this.nonDeploymentManagementContext.getSubscriptionManager().stopDelegatingForSubscribing();
        this.nonDeploymentManagementContext.getSubscriptionManager().stopDelegatingForPublishing();
        if (!this.isReadOnly()) {
            this.entity.onManagementNoLongerMaster();
            this.entity.onManagementStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onManagementStopped(ManagementTransitionInfo info) {
        EntityManagementSupport entityManagementSupport = this;
        synchronized (entityManagementSupport) {
            if (this.managementContext == null && this.nonDeploymentManagementContext.getMode() == NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_STOPPED) {
                return;
            }
            if (this.managementContext != info.getManagementContext()) {
                throw new IllegalStateException("Has different management context: " + this.managementContext + "; expected " + info.getManagementContext());
            }
            this.getSubscriptionContext().unsubscribeAll();
            this.entityChangeListener = EntityChangeListener.NOOP;
            this.managementContextUsable.set(false);
            this.currentlyDeployed.set(false);
            this.executionContext = null;
            this.subscriptionContext = null;
        }
        this.entity.invalidateReferences();
        entityManagementSupport = this;
        synchronized (entityManagementSupport) {
            this.managementContext = null;
            this.nonDeploymentManagementContext.setMode(NonDeploymentManagementContext.NonDeploymentManagementContextMode.MANAGEMENT_STOPPED);
        }
    }

    @VisibleForTesting
    @Beta
    public boolean isManagementContextReal() {
        return this.managementContextUsable.get();
    }

    public synchronized ManagementContext getManagementContext() {
        return this.managementContextUsable.get() ? this.managementContext : this.nonDeploymentManagementContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContext getExecutionContext() {
        if (this.executionContext != null) {
            return this.executionContext;
        }
        if (this.managementContextUsable.get()) {
            EntityManagementSupport entityManagementSupport = this;
            synchronized (entityManagementSupport) {
                if (this.executionContext != null) {
                    return this.executionContext;
                }
                this.executionContext = this.managementContext.getExecutionContext((Entity)this.entity);
                return this.executionContext;
            }
        }
        return this.nonDeploymentManagementContext.getExecutionContext((Entity)this.entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionContext getSubscriptionContext() {
        if (this.subscriptionContext != null) {
            return this.subscriptionContext;
        }
        if (this.managementContextUsable.get()) {
            EntityManagementSupport entityManagementSupport = this;
            synchronized (entityManagementSupport) {
                if (this.subscriptionContext != null) {
                    return this.subscriptionContext;
                }
                this.subscriptionContext = this.managementContext.getSubscriptionContext((Entity)this.entity);
                return this.subscriptionContext;
            }
        }
        return this.nonDeploymentManagementContext.getSubscriptionContext((Entity)this.entity);
    }

    public synchronized EntitlementManager getEntitlementManager() {
        return this.getManagementContext().getEntitlementManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptLegacyAutodeployment(String effectorName) {
        AbstractEntity e;
        EntityManagementSupport entityManagementSupport = this;
        synchronized (entityManagementSupport) {
            if (this.managementContext != null) {
                log.warn("Autodeployment suggested but not required for " + this.entity + "." + effectorName);
                return;
            }
            if (this.entity instanceof Application) {
                log.warn("Autodeployment with new management context triggered for " + this.entity + "." + effectorName + " -- will not be supported in future. Explicit manage call required.");
                if (this.initialManagementContext != null) {
                    this.initialManagementContext.getEntityManager().manage((Entity)this.entity);
                } else {
                    Entities.startManagement((Entity)this.entity);
                }
                return;
            }
        }
        if ("start".equals(effectorName) && (e = this.entity).getParent() != null && ((EntityInternal)e.getParent()).getManagementSupport().isDeployed()) {
            log.warn("Autodeployment in parent's management context triggered for " + this.entity + "." + effectorName + " -- will not be supported in future. Explicit manage call required.");
            ((EntityInternal)e.getParent()).getManagementContext().getEntityManager().manage((Entity)this.entity);
            return;
        }
        log.warn("Autodeployment not available for " + this.entity + "." + effectorName);
    }

    public EntityChangeListener getEntityChangeListener() {
        return this.entityChangeListener;
    }

    public String toString() {
        return super.toString() + "[" + (this.entity == null ? "null" : this.entity.getId()) + "]";
    }

    private class EntityChangeListenerImpl
    implements EntityChangeListener {
        private EntityChangeListenerImpl() {
        }

        @Override
        public void onChanged() {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
        }

        @Override
        public void onChildrenChanged() {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
        }

        @Override
        public void onLocationsChanged() {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
        }

        @Override
        public void onTagsChanged() {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
        }

        @Override
        public void onMembersChanged() {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
        }

        @Override
        public void onPolicyAdded(Policy policy) {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onManaged((BrooklynObject)policy);
        }

        @Override
        public void onEnricherAdded(Enricher enricher) {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onManaged((BrooklynObject)enricher);
        }

        @Override
        public void onFeedAdded(Feed feed) {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onManaged((BrooklynObject)feed);
        }

        @Override
        public void onPolicyRemoved(Policy policy) {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)policy);
        }

        @Override
        public void onEnricherRemoved(Enricher enricher) {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)enricher);
        }

        @Override
        public void onFeedRemoved(Feed feed) {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)feed);
        }

        @Override
        public void onAttributeChanged(AttributeSensor<?> attribute) {
            if (attribute.getPersistenceMode() != AttributeSensor.SensorPersistenceMode.NONE) {
                EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
            }
        }

        @Override
        public void onConfigChanged(ConfigKey<?> key) {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
        }

        @Override
        public void onEffectorStarting(Effector<?> effector, Object parameters) {
            Entitlements.checkEntitled(EntityManagementSupport.this.getEntitlementManager(), Entitlements.INVOKE_EFFECTOR, Entitlements.EntityAndItem.of((Entity)EntityManagementSupport.this.entity, Entitlements.StringAndArgument.of(effector.getName(), parameters)));
        }

        @Override
        public void onEffectorCompleted(Effector<?> effector) {
            EntityManagementSupport.this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)EntityManagementSupport.this.entity);
        }
    }
}

