/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class UsageRecord {
    private final String id;
    private final String description;
    private final String accountId;
    private final String accountName;
    private final String domainId;
    private final Date startDate;
    private final Date endDate;
    private final Date assignDate;
    private final String releaseDate;
    private final String zoneId;
    private final String virtualMachineId;
    private final String virtualMachineName;
    private final String serviceOfferingId;
    private final String templateId;
    private final String ipAddress;
    private final boolean isSourceNAT;
    private final double rawUsageHours;
    private final String usage;
    private final Long size;
    private final String type;
    private final UsageType usageType;
    private final String project;
    private final String projectId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUsageRecord(this);
    }

    @ConstructorProperties(value={"usageid", "description", "accountid", "account", "domainid", "startdate", "enddate", "assigndate", "releasedate", "zoneid", "virtualmachineid", "name", "offeringid", "templateid", "ipaddress", "issourcenat", "rawusage", "usage", "size", "type", "usagetype", "project", "projectid"})
    protected UsageRecord(String id, @Nullable String description, @Nullable String accountId, @Nullable String accountName, @Nullable String domainId, @Nullable Date startDate, @Nullable Date endDate, @Nullable Date assignDate, @Nullable String releaseDate, @Nullable String zoneId, @Nullable String virtualMachineId, @Nullable String virtualMachineName, @Nullable String serviceOfferingId, @Nullable String templateId, @Nullable String ipAddress, boolean isSourceNAT, double rawUsageHours, @Nullable String usage, @Nullable Long size, @Nullable String type, @Nullable UsageType usageType, @Nullable String project, @Nullable String projectId) {
        this.id = id;
        this.description = description;
        this.accountId = accountId;
        this.accountName = accountName;
        this.domainId = domainId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.assignDate = assignDate;
        this.releaseDate = releaseDate;
        this.zoneId = zoneId;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.serviceOfferingId = serviceOfferingId;
        this.templateId = templateId;
        this.ipAddress = ipAddress;
        this.isSourceNAT = isSourceNAT;
        this.rawUsageHours = rawUsageHours;
        this.usage = usage;
        this.size = size;
        this.type = type;
        this.usageType = usageType;
        this.project = project;
        this.projectId = projectId;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    public String getAccountName() {
        return this.accountName;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public Date getStartDate() {
        return this.startDate;
    }

    @Nullable
    public Date getEndDate() {
        return this.endDate;
    }

    @Nullable
    public Date getAssignDate() {
        return this.assignDate;
    }

    @Nullable
    public String getReleaseDate() {
        return this.releaseDate;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    @Nullable
    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    @Nullable
    public String getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    @Nullable
    public String getTemplateId() {
        return this.templateId;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isSourceNAT() {
        return this.isSourceNAT;
    }

    public double getRawUsageHours() {
        return this.rawUsageHours;
    }

    @Nullable
    public String getUsage() {
        return this.usage;
    }

    public Long getSize() {
        return this.size;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public UsageType getUsageType() {
        return this.usageType;
    }

    @Nullable
    public String getProject() {
        return this.project;
    }

    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.description, this.accountId, this.accountName, this.domainId, this.startDate, this.endDate, this.assignDate, this.releaseDate, this.zoneId, this.virtualMachineId, this.virtualMachineName, this.serviceOfferingId, this.templateId, this.ipAddress, this.isSourceNAT, this.rawUsageHours, this.size, this.usage, this.type, this.usageType, this.project, this.projectId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UsageRecord that = (UsageRecord)UsageRecord.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.accountId, (Object)that.accountId) && Objects.equal((Object)this.accountName, (Object)that.accountName) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.startDate, (Object)that.startDate) && Objects.equal((Object)this.endDate, (Object)that.endDate) && Objects.equal((Object)this.assignDate, (Object)that.assignDate) && Objects.equal((Object)this.releaseDate, (Object)that.releaseDate) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId) && Objects.equal((Object)this.virtualMachineName, (Object)that.virtualMachineName) && Objects.equal((Object)this.serviceOfferingId, (Object)that.serviceOfferingId) && Objects.equal((Object)this.templateId, (Object)that.templateId) && Objects.equal((Object)this.ipAddress, (Object)that.ipAddress) && Objects.equal((Object)this.isSourceNAT, (Object)that.isSourceNAT) && Objects.equal((Object)this.rawUsageHours, (Object)that.rawUsageHours) && Objects.equal((Object)this.usage, (Object)that.usage) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)((Object)this.usageType), (Object)((Object)that.usageType)) && Objects.equal((Object)this.project, (Object)that.project) && Objects.equal((Object)this.projectId, (Object)that.projectId);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("description", (Object)this.description).add("accountId", (Object)this.accountId).add("accountName", (Object)this.accountName).add("domainId", (Object)this.domainId).add("startDate", (Object)this.startDate).add("endDate", (Object)this.endDate).add("assignDate", (Object)this.assignDate).add("releaseDate", (Object)this.releaseDate).add("zoneId", (Object)this.zoneId).add("virtualMachineId", (Object)this.virtualMachineId).add("virtualMachineName", (Object)this.virtualMachineName).add("serviceOfferingId", (Object)this.serviceOfferingId).add("templateId", (Object)this.templateId).add("ipAddress", (Object)this.ipAddress).add("isSourceNAT", this.isSourceNAT).add("rawUsageHours", this.rawUsageHours).add("usage", (Object)this.usage).add("size", (Object)this.size).add("type", (Object)this.type).add("usageType", (Object)this.usageType).add("project", (Object)this.project).add("projectId", (Object)this.projectId);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String description;
        protected String accountId;
        protected String accountName;
        protected String domainId;
        protected Date startDate;
        protected Date endDate;
        protected Date assignDate;
        protected String releaseDate;
        protected String zoneId;
        protected String virtualMachineId;
        protected String virtualMachineName;
        protected String serviceOfferingId;
        protected String templateId;
        protected String ipAddress;
        protected boolean isSourceNAT;
        protected double rawUsageHours;
        protected String usage;
        protected Long size;
        protected String type;
        protected UsageType usageType;
        protected String project;
        protected String projectId;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T accountId(String accountId) {
            this.accountId = accountId;
            return this.self();
        }

        public T accountName(String accountName) {
            this.accountName = accountName;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T startDate(Date startDate) {
            this.startDate = startDate;
            return this.self();
        }

        public T endDate(Date endDate) {
            this.endDate = endDate;
            return this.self();
        }

        public T assignDate(Date assignDate) {
            this.assignDate = assignDate;
            return this.self();
        }

        public T releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this.self();
        }

        public T virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this.self();
        }

        public T serviceOfferingId(String serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this.self();
        }

        public T templateId(String templateId) {
            this.templateId = templateId;
            return this.self();
        }

        public T ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this.self();
        }

        public T isSourceNAT(boolean isSourceNAT) {
            this.isSourceNAT = isSourceNAT;
            return this.self();
        }

        public T rawUsageHours(double rawUsageHours) {
            this.rawUsageHours = rawUsageHours;
            return this.self();
        }

        public T usage(String usage) {
            this.usage = usage;
            return this.self();
        }

        public T size(Long size) {
            this.size = size;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public T usageType(UsageType usageType) {
            this.usageType = usageType;
            return this.self();
        }

        public T project(String project) {
            this.project = project;
            return this.self();
        }

        public T projectId(String projectId) {
            this.projectId = projectId;
            return this.self();
        }

        public UsageRecord build() {
            return new UsageRecord(this.id, this.description, this.accountId, this.accountName, this.domainId, this.startDate, this.endDate, this.assignDate, this.releaseDate, this.zoneId, this.virtualMachineId, this.virtualMachineName, this.serviceOfferingId, this.templateId, this.ipAddress, this.isSourceNAT, this.rawUsageHours, this.usage, this.size, this.type, this.usageType, this.project, this.projectId);
        }

        public T fromUsageRecord(UsageRecord in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).description(in.getDescription())).accountId(in.getAccountId())).accountName(in.getAccountName())).domainId(in.getDomainId())).startDate(in.getStartDate())).endDate(in.getEndDate())).assignDate(in.getAssignDate())).releaseDate(in.getReleaseDate())).zoneId(in.getZoneId())).virtualMachineId(in.getVirtualMachineId())).virtualMachineName(in.getVirtualMachineName())).serviceOfferingId(in.getServiceOfferingId())).templateId(in.getTemplateId())).ipAddress(in.getIpAddress())).isSourceNAT(in.isSourceNAT())).rawUsageHours(in.getRawUsageHours())).usage(in.getUsage())).size(in.getSize())).type(in.getType())).usageType(in.getUsageType())).project(in.getProject())).projectId(in.getProjectId());
        }
    }

    public static enum UsageType {
        RUNNING_VM(1),
        ALLOCATED_VM(2),
        IP_ADDRESS(3),
        NETWORK_BYTES_SENT(4),
        NETWORK_BYTES_RECEIVED(5),
        VOLUME(6),
        TEMPLATE(7),
        ISO(8),
        SNAPSHOT(9),
        SECURITY_GROUP(10),
        LOAD_BALANCER_POLICY(11),
        PORT_FORWARDING_RULE(12),
        NETWORK_OFFERING(13),
        VPN_USERS(14),
        UNRECOGNIZED(0);

        private int code;
        private static final Map<Integer, UsageType> INDEX;

        private UsageType(int code) {
            this.code = code;
        }

        public String toString() {
            return "" + this.code;
        }

        public static UsageType fromValue(String usageType) {
            Integer code = Integer.valueOf((String)Preconditions.checkNotNull((Object)usageType, (Object)"usageType"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])UsageType.values()), (Function)new Function<UsageType, Integer>(){

                public Integer apply(UsageType input) {
                    return input.code;
                }
            });
        }
    }
}

