/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import org.jclouds.azurecompute.domain.NetworkConfiguration;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class SubnetHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<NetworkConfiguration.Subnet> {
    private String name;
    private String addressPrefix;
    private String networkSecurityGroup;
    private StringBuilder currentText = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase("Subnet")) {
            this.name = attributes.getValue("name");
        }
    }

    public NetworkConfiguration.Subnet getResult() {
        NetworkConfiguration.Subnet result = NetworkConfiguration.Subnet.create(this.name, this.addressPrefix, this.networkSecurityGroup);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.addressPrefix = null;
        this.name = null;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("AddressPrefix")) {
            this.addressPrefix = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("NetworkSecurityGroup")) {
            this.networkSecurityGroup = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

