/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jclouds.azurecompute.domain.StorageService;
import org.jclouds.azurecompute.xml.ExtendedPropertiesHandler;
import org.jclouds.azurecompute.xml.StorageServicePropertiesHandler;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class StorageServiceHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<StorageService> {
    private URL url;
    private String serviceName;
    private StorageService.StorageServiceProperties storageServiceProperties;
    private boolean inStorageServiceProperties;
    private final StorageServicePropertiesHandler storageServicePropertiesHandler;
    private final Map<String, String> extendedProperties = Maps.newHashMap();
    private boolean inExtendedProperties;
    private final ExtendedPropertiesHandler extendedPropertiesHandler = new ExtendedPropertiesHandler();
    private String capability;
    private final StringBuilder currentText = new StringBuilder();

    @Inject
    StorageServiceHandler(DateService dateService) {
        this.storageServicePropertiesHandler = new StorageServicePropertiesHandler(dateService);
    }

    public StorageService getResult() {
        StorageService result = StorageService.create(this.url, this.serviceName, this.storageServiceProperties, this.extendedProperties, this.capability);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.serviceName = null;
        this.url = null;
        this.storageServiceProperties = null;
        this.extendedProperties.clear();
        this.capability = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("StorageServiceProperties".equals(qName)) {
            this.inStorageServiceProperties = true;
        } else if (this.inStorageServiceProperties) {
            this.storageServicePropertiesHandler.startElement(uri, localName, qName, attributes);
        } else if ("ExtendedProperties".equals(qName)) {
            this.inExtendedProperties = true;
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if ("StorageServiceProperties".equals(qName)) {
            this.inStorageServiceProperties = false;
            this.storageServiceProperties = this.storageServicePropertiesHandler.getResult();
        } else if (this.inStorageServiceProperties) {
            this.storageServicePropertiesHandler.endElement(ignoredUri, ignoredName, qName);
        } else if ("ExtendedProperties".equals(qName)) {
            this.inExtendedProperties = false;
            this.extendedProperties.putAll(this.extendedPropertiesHandler.getResult());
        } else if (this.inExtendedProperties) {
            this.extendedPropertiesHandler.endElement(ignoredUri, ignoredName, qName);
        } else if ("ServiceName".equals(qName)) {
            this.serviceName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if ("Url".equals(qName)) {
            String urlText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (urlText != null) {
                try {
                    this.url = new URL(urlText);
                }
                catch (MalformedURLException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        } else if ("Capability".equals(qName)) {
            this.capability = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inStorageServiceProperties) {
            this.storageServicePropertiesHandler.characters(ch, start, length);
        } else if (this.inExtendedProperties) {
            this.extendedPropertiesHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

