/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.azurecompute.xml.ResourceExtensionParameterValueHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ResourceExtensionReferenceHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Role.ResourceExtensionReference> {
    private String referenceName;
    private String publisher;
    private String name;
    private String version;
    private List<Role.ResourceExtensionReference.ResourceExtensionParameterValue> resourceExtensionParameterValues = Lists.newArrayList();
    private String state;
    private final ResourceExtensionParameterValueHandler resourceExtensionParameterValueHandler;
    private boolean inResourceExtensionParameterValue = false;
    private final StringBuilder currentText = new StringBuilder();

    @Inject
    ResourceExtensionReferenceHandler(ResourceExtensionParameterValueHandler resourceExtensionParameterValueHandler) {
        this.resourceExtensionParameterValueHandler = resourceExtensionParameterValueHandler;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("ResourceExtensionParameterValue")) {
            this.inResourceExtensionParameterValue = true;
        }
        if (this.inResourceExtensionParameterValue) {
            this.resourceExtensionParameterValueHandler.startElement(uri, localName, qName, attributes);
        }
    }

    public Role.ResourceExtensionReference getResult() {
        Role.ResourceExtensionReference result = Role.ResourceExtensionReference.create(this.referenceName, this.publisher, this.name, this.version, this.resourceExtensionParameterValues, this.state);
        this.resetState();
        return result;
    }

    private void resetState() {
        this.state = null;
        this.name = null;
        this.version = null;
        this.publisher = null;
        this.referenceName = null;
        this.resourceExtensionParameterValues = Lists.newArrayList();
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("ResourceExtensionParameterValue")) {
            this.inResourceExtensionParameterValue = false;
            this.resourceExtensionParameterValues.add(this.resourceExtensionParameterValueHandler.getResult());
        } else if (this.inResourceExtensionParameterValue) {
            this.resourceExtensionParameterValueHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("ReferenceName")) {
            this.referenceName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Publisher")) {
            this.publisher = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Version")) {
            this.version = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("State")) {
            this.state = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inResourceExtensionParameterValue) {
            this.resourceExtensionParameterValueHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

