/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.azurecompute.domain.ServiceCertificate;
import org.jclouds.azurecompute.xml.ServiceCertificateHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public final class ListServiceCertificatesHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<ServiceCertificate>> {
    private boolean inCertificate;
    private final ServiceCertificateHandler serviceCertificateHandler;
    private final ImmutableList.Builder<ServiceCertificate> certificates = ImmutableList.builder();

    @Inject
    ListServiceCertificatesHandler(ServiceCertificateHandler serviceCertificateHandler) {
        this.serviceCertificateHandler = serviceCertificateHandler;
    }

    public List<ServiceCertificate> getResult() {
        return this.certificates.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("Certificate")) {
            this.inCertificate = true;
        }
        if (this.inCertificate) {
            this.serviceCertificateHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Certificate")) {
            this.inCertificate = false;
            this.certificates.add((Object)this.serviceCertificateHandler.getResult());
        } else if (this.inCertificate) {
            this.serviceCertificateHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inCertificate) {
            this.serviceCertificateHandler.characters(ch, start, length);
        }
    }
}

