/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.azurecompute.domain.ProfileDefinition;
import org.jclouds.azurecompute.xml.ProfileDefinitionHandler;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;

public final class ListProfileDefinitionsHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<List<ProfileDefinition>> {
    private boolean inDefinition;
    private final ProfileDefinitionHandler profileDefinitionHandler;
    private final ImmutableList.Builder<ProfileDefinition> definitions = ImmutableList.builder();

    @Inject
    ListProfileDefinitionsHandler(ProfileDefinitionHandler profileDefinitionHandler) {
        this.profileDefinitionHandler = profileDefinitionHandler;
    }

    public List<ProfileDefinition> getResult() {
        return this.definitions.build();
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("Definition")) {
            this.inDefinition = true;
        }
        if (this.inDefinition) {
            this.profileDefinitionHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Definition")) {
            this.inDefinition = false;
            this.definitions.add((Object)this.profileDefinitionHandler.getResult());
        } else if (this.inDefinition) {
            this.profileDefinitionHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inDefinition) {
            this.profileDefinitionHandler.characters(ch, start, length);
        }
    }
}

