/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.CaseFormat;
import org.jclouds.azurecompute.domain.Error;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;

public final class ErrorHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Error> {
    private Error.Code code;
    private String message;
    private StringBuilder currentText = new StringBuilder();

    public Error getResult() {
        return Error.create(this.code, this.message);
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("Code")) {
            String codeText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.code = Error.Code.fromString(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, codeText));
        } else if (qName.equals("Message")) {
            this.message = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

