/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.util.List;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.azurecompute.xml.RoleHandler;
import org.jclouds.azurecompute.xml.RoleInstanceHandler;
import org.jclouds.azurecompute.xml.VirtualIPHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public final class DeploymentHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Deployment> {
    private String name;
    private Deployment.Slot slot;
    private Deployment.Status status;
    private String label;
    private String instanceStateDetails;
    private String virtualNetworkName;
    private List<Deployment.VirtualIP> virtualIPs = Lists.newArrayList();
    private List<Deployment.RoleInstance> roleInstanceList = Lists.newArrayList();
    private List<Role> roleList = Lists.newArrayList();
    private String instanceErrorCode;
    private boolean inRoleInstanceList;
    private boolean inRoleList;
    private boolean inListVirtualIPs;
    private final VirtualIPHandler virtualIPHandler;
    private final RoleInstanceHandler roleInstanceHandler;
    private final RoleHandler roleHandler;
    private final StringBuilder currentText = new StringBuilder();

    @Inject
    DeploymentHandler(VirtualIPHandler virtualIPHandler, RoleInstanceHandler roleInstanceHandler, RoleHandler roleHandler) {
        this.virtualIPHandler = virtualIPHandler;
        this.roleInstanceHandler = roleInstanceHandler;
        this.roleHandler = roleHandler;
    }

    public Deployment getResult() {
        return Deployment.create(this.name, this.slot, this.status, this.label, this.instanceStateDetails, this.instanceErrorCode, this.virtualIPs, this.roleInstanceList, this.roleList, this.virtualNetworkName);
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (qName.equals("VirtualIPs")) {
            this.inListVirtualIPs = true;
        } else if (qName.equals("RoleInstanceList")) {
            this.inRoleInstanceList = true;
        } else if (qName.equals("RoleList")) {
            this.inRoleList = true;
        }
        if (this.inRoleInstanceList) {
            this.roleInstanceHandler.startElement(url, name, qName, attributes);
        }
        if (this.inRoleList) {
            this.roleHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("RoleInstanceList")) {
            this.inRoleInstanceList = false;
        } else if (qName.equals("RoleInstance")) {
            this.roleInstanceList.add(this.roleInstanceHandler.getResult());
        } else if (this.inRoleInstanceList) {
            this.roleInstanceHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("RoleList")) {
            this.inRoleList = false;
        } else if (qName.equals("Role")) {
            this.roleList.add(this.roleHandler.getResult());
        } else if (this.inRoleList) {
            this.roleHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("VirtualIPs")) {
            this.inListVirtualIPs = false;
        } else if (qName.equals("VirtualIP")) {
            this.virtualIPs.add(this.virtualIPHandler.getResult());
        } else if (this.inListVirtualIPs) {
            this.virtualIPHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("Name") && this.name == null) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("DeploymentSlot")) {
            String slotText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.slot = Deployment.Slot.fromString(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, slotText));
        } else if (qName.equals("Status")) {
            String statusText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (this.status == null && statusText != null) {
                this.status = Deployment.Status.fromString(statusText);
            }
        } else if (qName.equals("Label")) {
            String labelText = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (labelText != null) {
                this.label = new String(BaseEncoding.base64().decode((CharSequence)labelText), Charsets.UTF_8);
            }
        } else if (qName.equals("InstanceStateDetails")) {
            this.instanceStateDetails = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("InstanceErrorCode")) {
            this.instanceErrorCode = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("VirtualNetworkName")) {
            this.virtualNetworkName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inListVirtualIPs) {
            this.virtualIPHandler.characters(ch, start, length);
        } else if (this.inRoleInstanceList) {
            this.roleInstanceHandler.characters(ch, start, length);
        } else if (this.inRoleList) {
            this.roleHandler.characters(ch, start, length);
        } else if (!(this.inListVirtualIPs || this.inRoleInstanceList || this.inRoleList)) {
            this.currentText.append(ch, start, length);
        }
    }
}

