/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.suppliers;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509ExtendedKeyManager;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;

class InMemoryKeyManagersSupplier
implements Supplier<KeyManager[]> {
    private final Crypto crypto;
    private final String identity;

    public InMemoryKeyManagersSupplier(Crypto crypto, String identity) {
        this.crypto = crypto;
        this.identity = identity;
    }

    public KeyManager[] get() {
        KeyManager[] keyManagers = null;
        int privateKeyBeginIdx = this.identity.indexOf("-----BEGIN PRIVATE KEY");
        int privateKeyEndIdx = this.identity.indexOf("-----END PRIVATE KEY");
        if (privateKeyBeginIdx != -1 && privateKeyEndIdx != -1) {
            try {
                String pemPrivateKey = this.identity.substring(privateKeyBeginIdx, privateKeyEndIdx + 26);
                StringBuilder pemCerts = new StringBuilder();
                int certsBeginIdx = 0;
                do {
                    if ((certsBeginIdx = this.identity.indexOf("-----BEGIN CERTIFICATE", certsBeginIdx)) < 0) continue;
                    int certsEndIdx = this.identity.indexOf("-----END CERTIFICATE", certsBeginIdx) + 26;
                    pemCerts.append(this.identity.substring(certsBeginIdx, certsEndIdx));
                    certsBeginIdx = certsEndIdx;
                } while (certsBeginIdx != -1);
                KeySpec keySpec = Pems.privateKeySpec((ByteSource)ByteSource.wrap((byte[])pemPrivateKey.getBytes(Charsets.UTF_8)));
                PrivateKey privateKey = this.crypto.rsaKeyFactory().generatePrivate(keySpec);
                Collection<? extends Certificate> certs = CertificateFactory.getInstance("X.509").generateCertificates(new ByteArrayInputStream(pemCerts.toString().getBytes(Charsets.UTF_8)));
                if (certs.isEmpty()) {
                    throw new IllegalStateException("Could not find any valid certificate");
                }
                X509Certificate certificate = (X509Certificate)certs.iterator().next();
                keyManagers = new KeyManager[]{new InMemoryKeyManager(certificate, privateKey)};
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return keyManagers;
    }

    private static class InMemoryKeyManager
    extends X509ExtendedKeyManager {
        private static final String DEFAULT_ALIAS = "azure";
        private final X509Certificate certificate;
        private final PrivateKey privateKey;

        public InMemoryKeyManager(X509Certificate certificate, PrivateKey privateKey) {
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return DEFAULT_ALIAS;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return DEFAULT_ALIAS;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return new X509Certificate[]{this.certificate};
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return new String[]{DEFAULT_ALIAS};
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.privateKey;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return new String[]{DEFAULT_ALIAS};
        }
    }
}

