/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.azurecompute.domain.StorageService;

public class StorageServicePredicates {
    public static Predicate<StorageService> sameLocation(final String location) {
        Preconditions.checkNotNull((Object)location, (Object)"location must be defined");
        return new Predicate<StorageService>(){

            public boolean apply(StorageService storageService) {
                return storageService.storageServiceProperties().location().equals(location);
            }

            public String toString() {
                return "sameLocation(" + location + ")";
            }
        };
    }

    public static Predicate<StorageService> status(final StorageService.Status status) {
        Preconditions.checkNotNull((Object)((Object)status), (Object)"status must be defined");
        return new Predicate<StorageService>(){

            public boolean apply(StorageService storageService) {
                return storageService.storageServiceProperties().status() == status;
            }

            public String toString() {
                return "status(" + (Object)((Object)status) + ")";
            }
        };
    }

    public static Predicate<StorageService> matchesName(final String defaultStorageAccountPrefix) {
        Preconditions.checkNotNull((Object)defaultStorageAccountPrefix, (Object)"defaultStorageAccountPrefix must be defined");
        return new Predicate<StorageService>(){

            public boolean apply(StorageService storageService) {
                return storageService.serviceName().matches(String.format("^%s[a-z]{10}$", defaultStorageAccountPrefix));
            }

            public String toString() {
                return "matchesName(" + defaultStorageAccountPrefix + ")";
            }
        };
    }
}

