/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.azurecompute.AzureComputeApi;
import org.jclouds.azurecompute.compute.AzureComputeServiceAdapter;
import org.jclouds.azurecompute.compute.config.AzureComputeServiceContextModule;
import org.jclouds.azurecompute.domain.Deployment;
import org.jclouds.azurecompute.domain.NetworkConfiguration;
import org.jclouds.azurecompute.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.domain.Role;
import org.jclouds.azurecompute.domain.Rule;
import org.jclouds.azurecompute.util.ConflictManagementPredicate;
import org.jclouds.azurecompute.util.NetworkSecurityGroups;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class AzureComputeSecurityGroupExtension
implements SecurityGroupExtension {
    protected final AzureComputeApi api;
    private final Predicate<String> operationSucceededPredicate;
    private final AzureComputeServiceContextModule.AzureComputeConstants azureComputeConstants;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    AzureComputeSecurityGroupExtension(AzureComputeApi api, Predicate<String> operationSucceededPredicate, AzureComputeServiceContextModule.AzureComputeConstants azureComputeConstants) {
        this.api = api;
        this.operationSucceededPredicate = operationSucceededPredicate;
        this.azureComputeConstants = azureComputeConstants;
    }

    public Set<SecurityGroup> listSecurityGroups() {
        return FluentIterable.from(this.api.getNetworkSecurityGroupApi().list()).transform((Function)new NetworkSecurityGroupSecurityGroupFunction()).toSet();
    }

    public Set<SecurityGroup> listSecurityGroupsInLocation(Location location) {
        return FluentIterable.from(this.api.getNetworkSecurityGroupApi().list()).transform((Function)new NetworkSecurityGroupSecurityGroupFunction()).toSet();
    }

    public Set<SecurityGroup> listSecurityGroupsForNode(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Deployment deployment = this.api.getDeploymentApiForService(name).get(name);
        final String virtualNetworkName = deployment.virtualNetworkName();
        ImmutableList subnetNames = FluentIterable.from(deployment.roleList()).transformAndConcat((Function)new Function<Role, Iterable<Role.ConfigurationSet>>(){

            public Iterable<Role.ConfigurationSet> apply(Role input) {
                return input.configurationSets();
            }
        }).transformAndConcat((Function)new Function<Role.ConfigurationSet, Iterable<Role.ConfigurationSet.SubnetName>>(){

            public Iterable<Role.ConfigurationSet.SubnetName> apply(Role.ConfigurationSet input) {
                return input.subnetNames();
            }
        }).transform((Function)new Function<Role.ConfigurationSet.SubnetName, String>(){

            public String apply(Role.ConfigurationSet.SubnetName input) {
                return input.name();
            }
        }).toList();
        return FluentIterable.from((Iterable)subnetNames).transform((Function)new Function<String, NetworkSecurityGroup>(){

            public NetworkSecurityGroup apply(String input) {
                return AzureComputeSecurityGroupExtension.this.api.getNetworkSecurityGroupApi().getNetworkSecurityGroupAppliedToSubnet(virtualNetworkName, input);
            }
        }).transform((Function)new NetworkSecurityGroupSecurityGroupFunction()).toSet();
    }

    public SecurityGroup getSecurityGroupById(String id) {
        return this.transformNetworkSecurityGroupToSecurityGroup(id);
    }

    public SecurityGroup createSecurityGroup(String name, Location location) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)location, (Object)"location");
        NetworkSecurityGroup networkSecurityGroup = NetworkSecurityGroup.create(name, name, location.getId(), null, null);
        String createNSGRequestId = this.api.getNetworkSecurityGroupApi().create(networkSecurityGroup);
        if (!this.operationSucceededPredicate.apply((Object)createNSGRequestId)) {
            String message = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("Create NSG" + name, createNSGRequestId, this.azureComputeConstants.operationTimeout());
            this.logger.warn(message, new Object[0]);
            throw new IllegalStateException(message);
        }
        return this.transformNetworkSecurityGroupToSecurityGroup(name);
    }

    private SecurityGroup transformNetworkSecurityGroupToSecurityGroup(String name) {
        NetworkSecurityGroup fullDetails = this.api.getNetworkSecurityGroupApi().getFullDetails(name);
        return fullDetails == null ? null : new NetworkSecurityGroupSecurityGroupFunction().apply(fullDetails);
    }

    public boolean removeSecurityGroup(final String id) {
        NetworkConfiguration networkConfiguration = this.api.getVirtualNetworkApi().getNetworkConfiguration();
        if (networkConfiguration != null) {
            for (NetworkConfiguration.VirtualNetworkSite virtualNetworkSite : networkConfiguration.virtualNetworkConfiguration().virtualNetworkSites()) {
                for (NetworkConfiguration.Subnet subnet : virtualNetworkSite.subnets()) {
                    NetworkSecurityGroup networkSecurityGroupAppliedToSubnet;
                    final String virtualNetworkName = virtualNetworkSite.name();
                    final String subnetName = subnet.name();
                    if (virtualNetworkName == null || subnetName == null || (networkSecurityGroupAppliedToSubnet = this.api.getNetworkSecurityGroupApi().getNetworkSecurityGroupAppliedToSubnet(virtualNetworkName, subnetName)) == null || !networkSecurityGroupAppliedToSubnet.name().equals(id)) continue;
                    this.logger.debug("Removing a networkSecurityGroup %s is already applied to subnet '%s' ...", new Object[]{id, subnetName});
                    if (new ConflictManagementPredicate(this.api, this.operationSucceededPredicate){

                        @Override
                        protected String operation() {
                            return AzureComputeSecurityGroupExtension.this.api.getNetworkSecurityGroupApi().removeFromSubnet(virtualNetworkName, subnetName, id);
                        }
                    }.apply(id)) continue;
                    String message = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("Remove NSG" + id + " from subnet " + subnetName, "Remove security group from subnet", this.azureComputeConstants.operationTimeout());
                    this.logger.warn(message, new Object[0]);
                    throw new IllegalStateException(message);
                }
            }
        }
        String deleteRequestId = this.api.getNetworkSecurityGroupApi().delete(id);
        return this.operationSucceededPredicate.apply((Object)deleteRequestId);
    }

    public SecurityGroup addIpPermission(IpPermission ipPermission, SecurityGroup group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        Preconditions.checkNotNull((Object)ipPermission, (Object)"ipPermission");
        String id = (String)Preconditions.checkNotNull((Object)group.getId(), (Object)"group.getId()");
        int priority = NetworkSecurityGroups.getFirstAvailablePriority(NetworkSecurityGroups.getCustomRules(this.api.getNetworkSecurityGroupApi().getFullDetails(group.getName())));
        String ruleName = NetworkSecurityGroups.createRuleName(this.azureComputeConstants.tcpRuleFormat(), ipPermission.getFromPort(), ipPermission.getToPort());
        this.addRuleToNetworkSecurityGroup(id, ruleName, priority, ipPermission);
        return this.transformNetworkSecurityGroupToSecurityGroup(id);
    }

    public SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.addIpPermission(permBuilder.build(), group);
    }

    public SecurityGroup removeIpPermission(IpPermission ipPermission, SecurityGroup group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        Preconditions.checkNotNull((Object)ipPermission, (Object)"ipPermission");
        String id = (String)Preconditions.checkNotNull((Object)group.getId(), (Object)"group.getId()");
        String ruleName = NetworkSecurityGroups.createRuleName(this.azureComputeConstants.tcpRuleFormat(), ipPermission.getFromPort(), ipPermission.getToPort());
        this.removeRuleFromNetworkSecurityGroup(id, ruleName);
        return this.transformNetworkSecurityGroupToSecurityGroup(id);
    }

    public SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.removeIpPermission(permBuilder.build(), group);
    }

    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    public boolean supportsGroupIds() {
        return false;
    }

    public boolean supportsPortRangesForGroups() {
        return false;
    }

    public boolean supportsExclusionCidrBlocks() {
        return false;
    }

    private void addRuleToNetworkSecurityGroup(String networkSecurityGroupId, String ruleName, int priority, IpPermission ipPermission) {
        String protocol = ipPermission.getIpProtocol().name();
        String destinationPortRange = ipPermission.getFromPort() == ipPermission.getToPort() ? String.valueOf(ipPermission.getToPort()) : String.format("%s-%s", ipPermission.getFromPort(), ipPermission.getToPort());
        String destinationAddressPrefix = ipPermission.getCidrBlocks().isEmpty() || ((String)Iterables.get((Iterable)ipPermission.getCidrBlocks(), (int)0)).equals("0.0.0.0/0") ? "*" : (String)Iterables.get((Iterable)ipPermission.getCidrBlocks(), (int)0);
        String setRuleToNSGRequestId = this.api.getNetworkSecurityGroupApi().setRule(networkSecurityGroupId, ruleName, Rule.create(ruleName, Rule.Type.Inbound, String.valueOf(priority), Rule.Action.Allow, "INTERNET", "*", destinationAddressPrefix, destinationPortRange, Rule.Protocol.fromString(protocol)));
        if (!this.operationSucceededPredicate.apply((Object)setRuleToNSGRequestId)) {
            String message = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("Add rule " + ruleName, setRuleToNSGRequestId, this.azureComputeConstants.operationTimeout());
            this.logger.warn(message, new Object[0]);
            throw new IllegalStateException(message);
        }
    }

    private void removeRuleFromNetworkSecurityGroup(String id, String ruleName) {
        String setRuleToNSGRequestId = this.api.getNetworkSecurityGroupApi().deleteRule(id, ruleName);
        if (!this.operationSucceededPredicate.apply((Object)setRuleToNSGRequestId)) {
            String message = AzureComputeServiceAdapter.generateIllegalStateExceptionMessage("Remove rule " + ruleName, setRuleToNSGRequestId, this.azureComputeConstants.operationTimeout());
            this.logger.warn(message, new Object[0]);
            throw new IllegalStateException(message);
        }
    }

    private class NetworkSecurityGroupSecurityGroupFunction
    implements Function<NetworkSecurityGroup, SecurityGroup> {
        private NetworkSecurityGroupSecurityGroupFunction() {
        }

        public SecurityGroup apply(NetworkSecurityGroup networkSecurityGroup) {
            SecurityGroupBuilder securityGroupBuilder = new SecurityGroupBuilder().id(networkSecurityGroup.name()).providerId(networkSecurityGroup.label()).name(networkSecurityGroup.name());
            if (networkSecurityGroup.rules() != null) {
                List<Rule> filteredRules = NetworkSecurityGroups.getCustomRules(networkSecurityGroup);
                Iterable permissions = Iterables.transform(filteredRules, (Function)new RuleToIpPermission());
                securityGroupBuilder.ipPermissions(permissions);
            }
            return securityGroupBuilder.build();
        }
    }

    private class RuleToIpPermission
    implements Function<Rule, IpPermission> {
        private RuleToIpPermission() {
        }

        public IpPermission apply(Rule rule) {
            IpPermission.Builder builder = IpPermission.builder();
            if (rule.name().matches(AzureComputeSecurityGroupExtension.this.azureComputeConstants.tcpRuleRegexp())) {
                builder.fromPort(this.extractPort(rule.name(), 0)).toPort(this.extractPort(rule.name(), 1));
            }
            builder.ipProtocol(rule.protocol().equals((Object)Rule.Protocol.ALL) ? IpProtocol.ALL : IpProtocol.valueOf((String)rule.protocol().getValue()));
            if (rule.destinationAddressPrefix().equals("*")) {
                builder.cidrBlock("0.0.0.0/0");
            } else {
                builder.cidrBlock(rule.destinationAddressPrefix());
            }
            return builder.build();
        }

        private int extractPort(String ruleName, int position) {
            return Integer.parseInt((String)Iterables.get((Iterable)Splitter.on((String)"-").omitEmptyStrings().split((CharSequence)ruleName.substring(4, ruleName.length())), (int)position));
        }
    }
}

