/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Map;
import org.jclouds.azurecompute.domain.CreateStorageServiceParams;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public final class CreateStorageServiceParamsToXML
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        CreateStorageServiceParams params = (CreateStorageServiceParams)CreateStorageServiceParams.class.cast(input);
        try {
            XMLBuilder builder = XMLBuilder.create((String)"CreateStorageServiceInput", (String)"http://schemas.microsoft.com/windowsazure").e("ServiceName").t(params.serviceName()).up();
            if (params.description() != null) {
                builder.e("Description").t(params.description()).up();
            }
            if (params.label() != null) {
                builder.e("Label").t(BaseEncoding.base64().encode(params.label().getBytes(Charsets.UTF_8))).up();
            }
            if (params.location() != null) {
                builder.e("Location").t(params.location()).up();
            }
            if (params.affinityGroup() != null) {
                builder.e("AffinityGroup").t(params.affinityGroup()).up();
            }
            if (params.extendedProperties() != null) {
                XMLBuilder extProps = builder.e("ExtendedProperties");
                for (Map.Entry<String, String> entry : params.extendedProperties().entrySet()) {
                    XMLBuilder extProp = extProps.e("ExtendedProperty");
                    extProp.e("Name").t(entry.getKey()).up();
                    extProp.e("Value").t(entry.getValue()).up();
                    extProp.up();
                }
                extProps.up();
            }
            builder.e("AccountType").t(params.accountType().name()).up();
            return (R)((HttpRequest.Builder)request.toBuilder().payload(builder.asString())).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

