/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.test.framework.TargetableTestComponentImpl;
import org.apache.brooklyn.test.framework.TestCase;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseImpl
extends TargetableTestComponentImpl
implements TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestCaseImpl.class);

    public void start(Collection<? extends Location> locations) {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STARTING);
        try {
            boolean continueOnFailure = Boolean.TRUE.equals(this.config().get(CONTINUE_ON_FAILURE));
            ArrayList childErrors = Lists.newArrayList();
            for (Entity child : this.getChildren()) {
                Boolean serviceUp = (Boolean)child.sensors().get(Attributes.SERVICE_UP);
                if (!(child instanceof Startable) || Boolean.TRUE.equals(serviceUp)) continue;
                try {
                    ((Startable)child).start(locations);
                }
                catch (Throwable t) {
                    Exceptions.propagateIfFatal((Throwable)t);
                    if (continueOnFailure) {
                        LOG.warn("Problem starting child " + child + " (continuing, and will throw at end)", t);
                        childErrors.add(t);
                        continue;
                    }
                    throw t;
                }
            }
            if (childErrors.size() > 0) {
                throw Exceptions.propagate((Iterable)childErrors);
            }
            this.sensors().set(Attributes.SERVICE_UP, (Object)true);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.RUNNING);
        }
        catch (Throwable t) {
            Exceptions.propagateIfInterrupt((Throwable)t);
            try {
                this.execOnErrorSpec();
            }
            catch (Throwable t2) {
                LOG.error("Problem executing on-error for " + this, t2);
                Exceptions.propagateIfInterrupt((Throwable)t2);
            }
            this.sensors().set(Attributes.SERVICE_UP, (Object)false);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    public void stop() {
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPING);
        this.sensors().set(Attributes.SERVICE_UP, (Object)false);
        try {
            boolean continueOnFailure = Boolean.TRUE.equals(this.config().get(CONTINUE_ON_FAILURE));
            ArrayList childErrors = Lists.newArrayList();
            for (Entity child : this.getChildren()) {
                try {
                    if (!(child instanceof Startable)) continue;
                    ((Startable)child).stop();
                }
                catch (Throwable t) {
                    Exceptions.propagateIfFatal((Throwable)t);
                    if (continueOnFailure) {
                        LOG.warn("Problem stopping child " + child + " (continuing, and will throw at end)", t);
                        childErrors.add(t);
                        continue;
                    }
                    throw t;
                }
            }
            if (childErrors.size() > 0) {
                throw Exceptions.propagate((Iterable)childErrors);
            }
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.STOPPED);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void restart() {
        ArrayList locations = Lists.newArrayList((Iterable)this.getLocations());
        this.stop();
        this.start(locations);
    }

    protected void execOnErrorSpec() {
        EntitySpec onErrorSpec = (EntitySpec)this.config().get(ON_ERROR_SPEC);
        if (onErrorSpec != null) {
            LOG.info("Creating and starting on-error child entity {} for {}", (Object)onErrorSpec.getType().getSimpleName(), (Object)this);
            Entity onErrorEntity = this.addChild(onErrorSpec);
            if (onErrorEntity instanceof Startable) {
                ((Startable)onErrorEntity).start(this.getLocations());
            }
        } else {
            LOG.debug("No on-error spec for {}", (Object)this);
        }
    }
}

