
We use a special maven plugin and scripts to automatically create the LICENSE
files, including all notices, based on metadata in overrides.yaml and **/source-inclusions.yaml.

First install  https://github.com/ahgittin/license-audit-maven-plugin


# Update license information

**TODO**: Need to re-work the script for the first Karaf-based release.

* Check if new projects are added to `brooklyn-client/cli/glide.yaml`; compare to and update `/brooklyn-client/cli/release/license/source-inclusions.yaml` &&  `overrides.yaml`
* Check for new/updated projects in UI (in `src/main/webapp/assets/js/libs`, `src/main/webapp/assets/css`); compare to and update `brooklyn-jsgui/src/main/license/source-inclusions.yaml` && `overrides.yaml`
* Check for newly introduced non-jar dependencies, add create corresponding `source-inclusions.yaml`. For example `brooklyn-server/server-cli/src/main/license/source-inclusions.yaml`.

In the `brooklyn-dist/dist/licensing` folder execute:

./make-all-licenses.sh || ( echo 'FAILED!!!' && rm LICENSE.autogenerated )

Cross check with running `mvn project-info-reports:dependencies` and checking the output at `target/site/dependencies.html`

# Quick Usage

In the usage/dist/ project of Brooklyn...

To see a tree of license info:

    mvn org.heneveld.maven:license-audit-maven-plugin:report \
        -Dformat=summary \
        -DlicensesPreferred=ASL2,ASL,EPL1,BSD-2-Clause,BSD-3-Clause,CDDL1.1,CDDL1,CDDL \
        -DoverridesFile=licensing/overrides.yaml \
        -DextrasFiles=`cat licensing/extras-files`


To create the LICENSE files needed for Apache Brooklyn
(consisting of: one in the root for the source build, in the dist project for the binary build,
and in `projects-with-custom-licenses` for those JARs which include other source code):

    pushd licensing
    ./make-all-licenses.sh || ( echo 'FAILED!!!' && rm LICENSE.autogenerated )
    popd

This combines the relevant `source-inclusions.yaml` files to create `extrasFile` files
for `license-audit-maven-plugin` then runs the `notices` target for the various dists we make.
If you need to add a new project to those which require custom LICENSE files, see below.


# CSV License Report

If you need to generate a CSV report of license usage, e.g. for use in a spreadsheet:

    mvn org.heneveld.maven:license-audit-maven-plugin:report \
        -Dformat=csv \
        -DlistDependencyIdOnly=true \
        -DsuppressExcludedDependencies=true \
        -DlicensesPreferred=ASL2,ASL,EPL1,BSD-2-Clause,BSD-3-Clause,CDDL1.1,CDDL1,CDDL \
        -DoverridesFile=licensing/overrides.yaml \
        -DextrasFiles=`cat licensing/extras-files` \
        -DoutputFile=dependencies-licenses.csv


# When Projects Need Custom Licenses

If a JAR includes 3rd party source code (as opposed to binary dependencies), it will typically 
require a custom LICENSE file.

To support this: 

1. Add the relative path to that project to `projects-with-custom-licenses`,

2. Create the necessary file structure and maven instructions:

* in `src/main/license/` put a `README.md` pointing here
* in `src/main/license/` put a `source-inclusion.yaml` listing the included 3rd-party projects by an `id:`
  (you may need to choose an ID; this should be a meaningful name, e.g. `typeahead.js` or `Swagger UI`)
* in `src/main/license/files` put the relevant non-LICENSE license files you want included (e.g. NOTICE)
* in `src/test/license/files` put the standard files *including* LICENSE to include in the test JAR
  (NB: these scripts don't generate custom licenses for test JARs, as so far that has not been needed)
* in `pom.xml` add instructions to include `src/{main,test}/license/files` in the main and test JARs

You can follow the pattern done for `cli` and `jsgui`.

3. In `licensing/overrides.yaml` in this directory, add the metadata for the included projects.

4. In `licensing/licenses/<your_project>/` include the relevant licenses for any included 3rd-party projects;
   look in `licensing/licenses/binary` for samples.

5. Run `make-all-licenses.sh` to auto-generate required config files and license copies,
   and to generate the LICENSE for your project.

Confirm that a LICENSE file for your project was generated, and that it is present in the JAR,
and then open a pull-request, and confirm the changes there are appropriate.

