#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#  http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

set -e

# generates a LICENSE file, including notices and other licenses as needed
# uses various env vars BROOKLYN_LICENSE_* to determine appropriate behaviour;
# see make-licenses.sh for examples

ls MAIN_LICENSE_ASL2 > /dev/null 2> /dev/null || ( echo "Must run in licensing directory (where this script lives)" > /dev/stderr && false )

if [ -z "${BROOKLYN_LICENSE_MODE}" ] ; then echo BROOKLYN_LICENSE_MODE must be set > /dev/stderr ; false ; fi


cat << EOF

This software is distributed under the Apache License, version 2.0. See (1) below.
This software is copyright (c) The Apache Software Foundation and contributors.

Contents:

  (1) This software license: Apache License, version 2.0
  (2) Notices for bundled software
  (3) Licenses for bundled software


EOF

echo "---------------------------------------------------"
echo
echo "(1) This software license: Apache License, version 2.0"
echo
cat MAIN_LICENSE_ASL2
echo
echo "---------------------------------------------------"
echo
echo "(2) Notices for bundled software"
echo
pushd .. > /dev/null
# add -X on next line to get debug info
mvn org.heneveld.maven:license-audit-maven-plugin:notices \
        -DlicensesPreferred=ASL2,ASL,EPL1,BSD-2-Clause,BSD-3-Clause,CDDL1.1,CDDL1,CDDL \
        -DoverridesFile=licensing/overrides.yaml \
        -DextrasFiles=${BROOKLYN_LICENSE_EXTRAS_FILES:-`cat licensing/extras-files`} \
        ${BROOKLYN_LICENSE_SPECIALS} \
        -DoutputFile=licensing/notices.autogenerated \
    > tmp_stdout 2> tmp_stderr || ( cat tmp_stdout && echo "----ERRORS----" && cat tmp_stderr && false )
rm tmp_std*
popd > /dev/null
cat notices.autogenerated

echo
echo "---------------------------------------------------"
echo
echo "(3) Licenses for bundled software"
echo
echo Contents:
echo
for x in licenses/${BROOKLYN_LICENSE_MODE}/* ; do head -1 $x | awk '{print "  "$0;}' ; done
echo
echo
for x in licenses/${BROOKLYN_LICENSE_MODE}/* ; do cat $x ; echo ; done

