/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.internal.winrm;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.util.core.internal.winrm.WinRmToolResponse;
import org.apache.brooklyn.util.time.Duration;

@Beta
public interface WinRmTool {
    public static final String BROOKLYN_CONFIG_KEY_PREFIX = (String)Preconditions.checkNotNull((Object)"brooklyn.winrm.config.", (Object)"static final initializer classload ordering problem");
    public static final ConfigKey<String> PROP_HOST = ConfigKeys.newStringConfigKey((String)"host", (String)"Host to connect to (required)", null);
    public static final ConfigKey<Integer> PROP_PORT = ConfigKeys.newIntegerConfigKey((String)"port", (String)"WinRM port to use when connecting to the remote machine");
    public static final ConfigKey<Boolean> USE_HTTPS_WINRM = ConfigKeys.newBooleanConfigKey((String)"winrm.useHttps", (String)"The parameter tells the machine sensors whether the winrm port is over https. If the parameter is true then 5986 will be used as a winrm port.", (Boolean)false);
    public static final ConfigKey<Integer> RETRIES_OF_NETWORK_FAILURES = ConfigKeys.newIntegerConfigKey((String)"retriesOfNetworkFailures", (String)"The parameter sets the number of retries for connection failures. If you use high value, consider taking care for the machine's network.", (Integer)4);
    public static final ConfigKey<Map<String, String>> ENVIRONMENT = MapConfigKey.builder((TypeToken)new TypeToken<Map<String, String>>(){}).name("winrm.environment").description("WinRM Environment variables").build();
    @Beta
    public static final ConfigKey<Boolean> USE_NTLM = ConfigKeys.newBooleanConfigKey((String)"winrm.useNtlm", (String)"The parameter configures tells the machine sensors whether the winrm port is over https. If the parameter is true then 5986 will be used as a winrm port.", (Boolean)true);
    @Beta
    public static final ConfigKey<String> COMPUTER_NAME = ConfigKeys.newStringConfigKey((String)"winrm.computerName", (String)"Windows Computer Name to use for authentication.");
    public static final ConfigKey<String> PROP_USER = ConfigKeys.newStringConfigKey((String)"user", (String)"User to connect as", null);
    public static final ConfigKey<String> PROP_PASSWORD = ConfigKeys.newStringConfigKey((String)"password", (String)"Password to use to connect", null);
    public static final ConfigKey<String> OPERATION_TIMEOUT = ConfigKeys.newStringConfigKey((String)"winrm.operationTimeout", (String)"WinRM OperationTimeout. If no output is available before the wsman:OperationTimeout expires, the server MUST return a WSManFault with the Code attribute equal to \"2150858793\". When the client receives this fault, it will issue another Receive request. winrm4j also sets the tcp socket timeout to a rounded up value", (String)"1m");
    public static final ConfigKey<Integer> PROP_EXEC_TRIES = ConfigKeys.newIntegerConfigKey((String)"execTries", (String)"Max number of times to attempt WinRM operations", (Integer)1);
    public static final ConfigKey<Duration> PROP_EXEC_RETRY_DELAY = ConfigKeys.newConfigKey(Duration.class, (String)"execRetryDelay", (String)"Max time between retries (backing off exponentially to this delay)", (Object)Duration.TEN_SECONDS);
    @Beta
    public static final ConfigKey<Integer> COPY_FILE_CHUNK_SIZE_BYTES = ConfigKeys.newIntegerConfigKey((String)"windows.copy.file.size.bytes", (String)"Size of file chunks (in bytes) to be used when copying a file to the remote server", (Integer)1024);
    public static final ConfigKey<String> ADDITIONAL_CONNECTION_METADATA = ConfigKeys.newStringConfigKey((String)"additional.connection.metadata", (String)"Can be used to pass additional custom data to the WinrmTool, which is especially useful if writing a bespoke tool implementation");

    @Deprecated
    public WinRmToolResponse executeScript(List<String> var1);

    public WinRmToolResponse executeCommand(List<String> var1);

    public WinRmToolResponse executePs(List<String> var1);

    public WinRmToolResponse copyToServer(InputStream var1, String var2);
}

