/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.xml;

import com.google.common.collect.Lists;
import java.util.List;
import org.jclouds.azurecompute.domain.NetworkConfiguration;
import org.jclouds.azurecompute.xml.AddressSpaceHandler;
import org.jclouds.azurecompute.xml.SubnetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class VirtualNetworkSiteHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<NetworkConfiguration.VirtualNetworkSite> {
    private String id;
    private String name;
    private String location;
    private NetworkConfiguration.AddressSpace addressSpace;
    private List<NetworkConfiguration.Subnet> subnets = Lists.newArrayList();
    private boolean inSubnet;
    private boolean inAddressSpace;
    private final SubnetHandler subnetHandler = new SubnetHandler();
    private final AddressSpaceHandler addressSpaceHandler = new AddressSpaceHandler();
    private StringBuilder currentText = new StringBuilder();

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase("VirtualNetworkSite")) {
            this.name = attributes.getValue("name");
            this.location = attributes.getValue("Location");
        }
        if (qName.equals("AddressSpace")) {
            this.inAddressSpace = true;
        } else if (qName.equals("Subnet")) {
            this.inSubnet = true;
        }
        if (this.inAddressSpace) {
            this.addressSpaceHandler.startElement(uri, this.name, qName, attributes);
        }
        if (this.inSubnet) {
            this.subnetHandler.startElement(uri, this.name, qName, attributes);
        }
    }

    private void resetState() {
        this.location = null;
        this.name = null;
        this.id = null;
        this.subnets = Lists.newArrayList();
        this.addressSpace = null;
    }

    public NetworkConfiguration.VirtualNetworkSite getResult() {
        NetworkConfiguration.VirtualNetworkSite result = NetworkConfiguration.VirtualNetworkSite.create(this.id, this.name, this.location, this.addressSpace, this.subnets);
        this.resetState();
        return result;
    }

    public void endElement(String ignoredUri, String ignoredName, String qName) {
        if (qName.equals("AddressSpace")) {
            this.inAddressSpace = false;
            this.addressSpace = this.addressSpaceHandler.getResult();
        } else if (this.inAddressSpace) {
            this.addressSpaceHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("Subnet")) {
            this.inSubnet = false;
            this.subnets.add(this.subnetHandler.getResult());
        } else if (this.inSubnet) {
            this.subnetHandler.endElement(ignoredUri, ignoredName, qName);
        } else if (qName.equals("Id")) {
            this.id = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Name")) {
            this.name = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (qName.equals("Location")) {
            this.location = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inAddressSpace) {
            this.addressSpaceHandler.characters(ch, start, length);
        } else if (this.inSubnet) {
            this.subnetHandler.characters(ch, start, length);
        } else if (!this.inAddressSpace && !this.inSubnet) {
            this.currentText.append(ch, start, length);
        }
    }
}

